/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSPROVISIONATOR_H
#define RDSPROVISIONATOR_H

#include <ServiceProxy>
#include <QxtPimpl>

class RdsProvisionatorPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsProvisionator : public QtRpc::ServiceProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsProvisionator);
	QTRPC_SERVICEPROXY_PIMPL(RdsProvisionator);

public:
	RdsProvisionator(QObject *parent = 0);
	RdsProvisionator(const RdsProvisionator &other);
	~RdsProvisionator();
	RdsProvisionator& operator=(const RdsProvisionator &other);

public slots:
	ReturnValue provisionExistingDomain(const QVariantMap &settings);
	ReturnValue writeRawConf(const QVariantMap &map);
	ReturnValue networkWorked();

	ReturnValue provision(const QVariantMap &map);
	ReturnValue applyNetworkSettings(const QVariantMap &map);

	ReturnValue getDefaultSettings() const;
	ReturnValue setNetworkSettings(const QVariantMap& settings, bool updatehosts = false);

	ReturnValue provisionDhcp(QVariantMap settings);
	
	ReturnValue installFinished();

signals:
	QtRpc::Event minorProgress(const QString &str);
	QtRpc::Event majorProgress(const QString &str);
	QtRpc::Event completed(const ReturnValue &ret);

};

#endif
