/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSPROVISIONATOR_H
#define RDSPROVISIONATOR_H

#include <ClientProxy>
#include <QTimer>
#include <QTime>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsProvisionator : public QtRpc::ClientProxy
{
	Q_OBJECT
	QTRPC_CLIENTPROXY(RdsProvisionator);
public:
	RdsProvisionator(QObject *parent = 0);
	~RdsProvisionator();

	void asyncConnect(QString user, QString pass, QString ip, QString oldip, int port, QString service, QVariantMap settings);

public slots:
	void onMinorProgress(const QString &msg);
	void onMajorProgress(const QString &msg);
	void onCompleted(const ReturnValue &ret);
	void timeout();
	void connected(uint id, ReturnValue ret);
	void doConnect();

signals:
	ReturnValue provisionExistingDomain(const QVariantMap &settings);
	ReturnValue writeRawConf(const QVariantMap &map);
	ReturnValue networkWorked();
	ReturnValue provision(const QVariantMap &map);
	ReturnValue getDefaultSettings() const;
	ReturnValue setNetworkSettings(const QVariantMap &settings);
	ReturnValue setNetworkSettings(QObject *obj, const char *slot, const QVariantMap &settings);
	QtRpc::Event minorProgress(const QString &str);
	QtRpc::Event majorProgress(const QString &str);
	QtRpc::Event completed(const ReturnValue &ret);

private:
	QString _user;
	QString _pass;
	QString _ip;
	QString _oldip;
	QString _service;
	int _port;
	QVariantMap _settings;
	QTimer *_timer;
	QTime _time;
	bool _reverted;
};

#endif
