/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDHCPSHAREDNETWORK_H
#define RDSDHCPSHAREDNETWORK_H

#include <RdsDhcpValues>
#include <QxtPimpl>

class RdsDhcpSharedNetworkPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsDhcpSharedNetwork : public RdsDhcpValues
{
	friend class RdsDhcpValues;
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsDhcpSharedNetwork);
	QTRPC_SERVICEPROXY_PIMPL(RdsDhcpSharedNetwork);
public:
	RdsDhcpSharedNetwork(const RdsDhcpSharedNetwork &other);
	~RdsDhcpSharedNetwork();
	RdsDhcpSharedNetwork& operator=(const RdsDhcpSharedNetwork &other);

protected:
	RdsDhcpSharedNetwork();
	virtual void setData(void* data);

public slots:
	/**
	 *        Gets the shared network name
	 * @return Qstring containing the shared network name
	 */
	ReturnValue name() const;
	/**
	 *        Sets the name of the shared network
	 * @param name the name of the shared network
	 * @return true
	 */
	ReturnValue setName(const QString &name);

};

#endif
