/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSJOB_P_H
#define RDSJOB_P_H

#include <QxtPimpl>
#include <QStringList>
#include <QTimer>
#include <QDateTime>
#include <QMutex>
#include "rdsjob.h"

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsJobPrivate : public QxtPrivate<RdsJob>
{
public:
	RdsJobPrivate()
			: status(RdsJob::Stopped),
			percent(0), // lol int
			canPause(false),
			_mutex(QMutex::Recursive)
	{
	}
	RdsJobPrivate& operator=(const RdsJobPrivate& other);
	QString name;
	QString id;
	QString description;
	RdsJob::Status status;
	int percent;
	QString progressText;
	QString progressDetails;
	QList<RdsJob::LogEntry> log;
	bool canPause;
	QTimer timer;
	QSharedPointer<RdsJob> proxyJob;

	// I do this so that const functions can lock
	QMutex _mutex;
	inline QMutex* mutex() const
	{
		return const_cast<QMutex*>(&_mutex);
	}

	QList<RdsJob::LogEntry> logQueue;
	QTimer logTimer;
};

#endif
