/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsjobmanager.h"
#include "rdsjobmanager_p.h"
#include <RdsEntity>

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsJobManager);

RdsJobManagerData& RdsJobManagerPrivate::data()
{
	static RdsJobManagerData data;
	return data;
}

RdsJobManager::RdsJobManager(QObject *parent)
		: RdsEntityManager(parent)
{
}

RdsJobManager::RdsJobManager(const RdsJobManager& other)
{
	operator=(other);
}

RdsJobManager::~RdsJobManager()
{
}

RdsJobManager& RdsJobManager::operator=(const RdsJobManager & other)
{
	return *this;
}

ReturnValue RdsJobManager::listEntities(const QString &base, bool loadmore) const
{
	QMutexLocker locker(&qxt_d().data().mutex);
	ReturnValue ret;
	if ((base == "") || (base == "root"))
	{
		RdsEntity entity;
		entity.setId("root");
		entity.setType("root");
		entity.setVisible(false);
		entity.setName("");
		entity.setParent("");

		foreach(QString name, qxt_d().data().jobs.keys())
		{
			ret = listEntities(name);
			if (!ret.isError()) entity.children() << ret.value<RdsEntity>();
		}
		return ReturnValue::fromValue<RdsEntity>(entity);
	}

	if (!qxt_d().data().jobs.contains(base))
	{
		return ReturnValue(1, "Entity not found");
	}

	RdsEntity entity;
	entity.setId(base);
	entity.setType("job");
	entity.setVisible(true);
	entity.setName(base);
	entity.setParent("root");

	return ReturnValue::fromValue<RdsEntity>(entity);
}

ReturnValue RdsJobManager::job(const QString& job)
{
	QMutexLocker locker(&qxt_d().data().mutex);
	if (!qxt_d().data().jobs.contains(job))
	{
		return ReturnValue(1, "A job by that name could not be found.");
	}
	QWeakPointer<RdsJob> j = qxt_d().data().jobs.value(job);
	if (j.isNull())
	{
		qxt_d().data().jobs.remove(job);
		return ReturnValue(1, "The specified job no longer exists.");
	}
	return j.data();
}

RdsJobManagerData::RdsJobManagerData()
		: mutex(QMutex::Recursive)
{
}

ReturnValue RdsJobManagerData::registerJob(const QString &name, RdsJob* job)
{
	QMutexLocker locker(&mutex);
	QString finalName = name;
	for (int i = 0; jobs.contains(finalName); finalName = name + "_" + QString::number(++i));

	jobs.insert(finalName, job->getSharedPointer());
	return finalName;
}

ReturnValue RdsJobManagerData::unregisterJob(const QString &name)
{
	QMutexLocker locker(&mutex);
	if (!jobs.contains(name))
		return ReturnValue(1, "A job by that name does not exists");

	jobs.remove(name);
	return true;
}




