/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSMOUNTPOINT_H
#define RDSMOUNTPOINT_H

#include <QxtPimpl>
#include <ReturnValue>

#include <sys/types.h>
#include <attr/xattr.h>
#include <sys/statfs.h>
#include <ServiceProxy>

class RdsMountPointPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsMountPoint : public QtRpc::ServiceProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsMountPoint);
	QTRPC_SERVICEPROXY_PIMPL(RdsMountPoint);
public:
	RdsMountPoint();
	RdsMountPoint(const char *mountPoint);
	RdsMountPoint(const QString &mountPoint);
	RdsMountPoint(const RdsMountPoint &other);
	~RdsMountPoint();
	RdsMountPoint &operator=(const RdsMountPoint &object);	
	
	static QString mountPointOfPath(const QString &str);
	
public slots:
	ReturnValue volume();
	ReturnValue path() const;
	ReturnValue size() const;
	ReturnValue freeSpace() const;
	ReturnValue supportsNtAcls() const;
	ReturnValue isMounted();
	ReturnValue mount();
	ReturnValue unMount();
};

Q_DECLARE_METATYPE(RdsMountPoint);

#endif
