/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef SAMBACONFIGPARSER_P_H
#define SAMBACONFIGPARSER_P_H

#include <QxtPimpl>
#include <QTemporaryFile>
#include <QString>
#include <QMutex>
#include "rdssambaconfigparser.h"

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsSambaConfigParserPrivate : public QxtPrivate<RdsSambaConfigParser>
{
public:
	RdsSambaConfigParserPrivate()
	{
	}
	QString configFile;
	static bool& parsed();
	static QMutex& mutex();
	static QMap<QString, QMap<QString, QPair<QStringList, QString> > >& values();
	static QMap<QString, QMap<QString, QPair<QStringList, QString> > >& rdsValues();
	static QMap<QString, QMap<QString, QPair<QStringList, QString> > >& disabledValues();
	static QMap<QString, QMap<QString, QPair<QStringList, QString> > >& disabledRdsValues();
};

#endif
