/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSCHEDULEMANAGER_H
#define RDSSCHEDULEMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>
#include <RdsSchedule>

class RdsScheduleManagerPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsScheduleManager : public RdsEntityManager
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsScheduleManager);
	QTRPC_SERVICEPROXY_PIMPL(RdsScheduleManager);
public:
	RdsScheduleManager();
	RdsScheduleManager(const RdsScheduleManager& other);
	~RdsScheduleManager();

	ReturnValue addEvent(const QString& name, const RdsSchedule& schedule, QObject* obj, const char* slot);
	ReturnValue removeEvent(const QString& name);
	ReturnValue eventExists(const QString& name) const;

	RdsScheduleManager& operator=(const RdsScheduleManager& other);

public slots:
	virtual ReturnValue listEntities(const QString &base, bool loadmore) const;
	ReturnValue auth(QtRpc::AuthToken token);
};

#endif
