/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdssettings.h"
#include "rdssettings_p.h"
#include <QDebug>
#include <ReturnValue>
#include <QStringList>
#include <QVariantMap>
#include <assert.h>
#include <QFile>

#define SETTINGS_FILE "/etc/rds.conf"

QSettings*& RdsSettingsPrivate::rdssettings()
{
	static QSettings* settings(0);
	return settings;
}

QMutex& RdsSettingsPrivate::mutex()
{
	static QMutex mutex(QMutex::Recursive);
	return mutex;
}

RdsSettings::RdsSettings()
{
	QXT_INIT_PRIVATE(RdsSettings);
	qxt_d().shouldunlock = false;
	qxt_d().mutex().lock();
	if (qxt_d().rdssettings() == NULL)
	{
		qxt_d().rdssettings() = new QSettings(SETTINGS_FILE, QSettings::IniFormat);
	}
}

RdsSettings::RdsSettings(const RdsSettings &s)
{
	Q_UNUSED(s); //We don't actually copy anything
	QXT_INIT_PRIVATE(RdsSettings);
	qCritical() << "You may not copy an RdsSettings object";
	assert(false); // DON'T COPY THE FLOPPY
}


RdsSettings::~RdsSettings()
{
	qxt_d().rdssettings()->sync();
	qxt_d().mutex().unlock();
}

void RdsSettings::lock()
{
	qxt_d().mutex().lock();
}

void RdsSettings::unlock()
{
	qxt_d().mutex().unlock();
}

QSettings *RdsSettings::operator->()
{
	return(qxt_d().rdssettings());
}

ReturnValue RdsSettings::renameGroup(const QString& oldname, const QString& newname)
{
	QSettings* settings = qxt_d().rdssettings(); // lazy!
	if (!settings->childGroups().contains(oldname))
	{
		return ReturnValue(1, "Group does not exist");
	}
	if (settings->childGroups().contains(newname))
	{
		return ReturnValue(1, "Destination group already exists");
	}
	settings->beginGroup(oldname);
	QVariantMap map;
	foreach(QString key, settings->allKeys())
	{
		map.insert(key, settings->value(key));
	}
	settings->remove(""); // Trick to remove all keys in the current group
	settings->endGroup();
	settings->beginGroup(newname);
	foreach(QString key, map.keys())
	{
		settings->setValue(key, map.value(key));
	}
	settings->endGroup();
	return map.count();
}


