/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsstoragedevicemanager.h"
#include "rdsstoragedevicemanager_p.h"
#include <QDebug>
#include <RdsStorageDevice>
#include <RdsEntity>
#include <QStringList>

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsStorageDeviceManager);

RdsStorageDeviceManager::RdsStorageDeviceManager(QObject *parent)
		: RdsEntityManager(parent)
{
	QXT_INIT_PRIVATE(RdsStorageDeviceManager);
}

RdsStorageDeviceManager::RdsStorageDeviceManager(const RdsStorageDeviceManager &other)
	: RdsEntityManager(NULL)
{
	Q_UNUSED(other);
	QXT_INIT_PRIVATE(RdsStorageDeviceManager);
}

RdsStorageDeviceManager::~RdsStorageDeviceManager()
{
}

RdsStorageDeviceManager &RdsStorageDeviceManager::operator=(const RdsStorageDeviceManager &other)
{
	Q_UNUSED(other);
	return(*this);
}


ReturnValue RdsStorageDeviceManager::auth(QtRpc::AuthToken token)
{
	createInternalObject();
	if (token.serverData().contains("authenticated") && (token.serverData().value("authenticated").toBool() == true))
		return(true);
	else
		return(ReturnValue(1, "Not Authenticated"));
}

ReturnValue RdsStorageDeviceManager::listEntities(const QString &id, bool loadmore) const
{
	ReturnValue ret;
	if ((id == "") || (id == "root"))
	{
		RdsEntity entity;
		entity.setId("root");
		entity.setType("root");
		entity.setVisible(false);
		entity.setName("");
		entity.setParent("");

		foreach(QString device, RdsStorageDevice::list().toStringList())
		{
			// The V: is there so that we can have a volume called root without breaking everything :P
			ret = listEntities(device, loadmore);
			if (!ret.isError()) entity.children() << ret.value<RdsEntity>();
		}

		return ReturnValue::fromValue<RdsEntity>(entity);
	}

	RdsStorageDevice device(id);
	RdsEntity entity;
	entity.setId(id);
	entity.setType("volume");
	entity.setVisible(true);
	entity.setName(device.name().toString());
	entity.setParent("root");
	entity.metadata()["size"] = device.size().toULongLong();
	entity.metadata()["type"] = device.type().toString();
	//qDebug() << "In Use:" << device.name().toString() << device.inUse().toBool() << device.inUse();
	entity.metadata()["used"] = device.inUse().toBool();
	entity.metadata()["model"] = device.model().toString();
	entity.metadata()["serial"] = device.serialNumber().toString();

	return ReturnValue::fromValue<RdsEntity>(entity);
}

ReturnValue RdsStorageDeviceManager::device(const QString &id) const
{
	return(new RdsStorageDevice(id));
}
