/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSSTORAGEMANAGER_H
#define RDSSTORAGEMANAGER_H

#include <QxtPimpl>
#include <QList>
#include <ReturnValue>
#include <ServiceProxy>

class RdsStorageManagerPrivate;
class RdsStorageDevice;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsStorageManager : public QtRpc::ServiceProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsStorageManager);
	QTRPC_SERVICEPROXY_PIMPL(RdsStorageManager);
public:
	RdsStorageManager();
	~RdsStorageManager();
	RdsStorageManager &operator=(const RdsStorageManager &object);

public slots:
	ReturnValue list();
	ReturnValue getVolume(const QString& device);
	ReturnValue addVolume();
	ReturnValue removeVolume();
};

#endif
