/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSVOLUME_H
#define RDSVOLUME_H

#include <QxtPimpl>
#include <ReturnValue>
#include <ServiceProxy>

class RdsVolumePrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsVolume : public QtRpc::ServiceProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsVolume);
	QTRPC_SERVICEPROXY_PIMPL(RdsVolume);
public:
	RdsVolume();
	RdsVolume(const QString &volume);
	RdsVolume(const char *volume); //because now there's a ReturnValue constructor...
	RdsVolume(const RdsVolume &other);
	~RdsVolume();
	RdsVolume &operator=(const RdsVolume &volume);

public slots:
	virtual ReturnValue initialize(); // This wipes out the fs and rebuilds it...
	virtual ReturnValue isAdded() const; // if it's registered to RDS or not
	virtual ReturnValue isActivated() const; // if it's in /volumes/ or not, this is different from isMounted...
	virtual ReturnValue storageDevice();
	virtual ReturnValue mountPoint() const;
	// This function should really be called "activate", not "mount"...
	virtual ReturnValue mount(); // mount in /volumes/ if it's not mounted, otherwise activate it
	virtual ReturnValue mount(const QString &path, const QStringList &options);
	virtual ReturnValue unmount();
	virtual ReturnValue isMounted() const; // if it's mounted /anywhere/... If you're looking for if it's in /volumes/, check isActivated
	virtual ReturnValue deviceFile() const;
	virtual ReturnValue path() const;
	virtual ReturnValue size() const;
	virtual ReturnValue freeSpace() const;
	virtual ReturnValue supportsNtAcls() const;
	virtual ReturnValue fsType() const;
	virtual ReturnValue type() const; // type of volume class
	virtual ReturnValue status() const; // generic status (Normal, Warning, Error, Disconnected)
	virtual ReturnValue statusText() const; // simple status description
	virtual ReturnValue statusDetails() const; // detailed status report
	virtual ReturnValue name();
	virtual ReturnValue setName(const QString &name); // we need to move the mount point if this is changed while mounted
	virtual ReturnValue id() const; // unique device ID
	static ReturnValue list();
	virtual ReturnValue mkfs(const QString &type, const QStringList &options, quint64 blocks);
	virtual ReturnValue serialNumber() const;
	virtual ReturnValue model() const;
	virtual ReturnValue isEjectable() const;
	virtual ReturnValue eject();
};

Q_DECLARE_METATYPE(RdsVolume);

#endif
