/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsadobject.h"
#include "rdsadobject_p.h"
#include <RdsSid>
#include <RdsNtSecurityDescriptor>
#include <RdsGuid>
#include <ReturnValue>
#include <RdsUtils>
#include <QDebug>

RdsAdObject::RdsAdObject()
	: RdsLdapObject(RdsUtils::baseDn())
{
	QXT_INIT_PRIVATE(RdsAdObject);
}

RdsAdObject::RdsAdObject(const QString &dn)
		: RdsLdapObject(dn)
{
	QXT_INIT_PRIVATE(RdsAdObject);
}

RdsAdObject::RdsAdObject(QString dn, RdsLdapSession *session)
		: RdsLdapObject(dn, session)
{
	QXT_INIT_PRIVATE(RdsAdObject);
}

RdsAdObject::RdsAdObject(const RdsAdObject &other)
		: RdsLdapObject(other)
{
	QXT_INIT_PRIVATE(RdsAdObject);
}


RdsAdObject::~RdsAdObject()
{
}

RdsAdObject& RdsAdObject::operator=(const RdsAdObject & other)
{
	RdsLdapObject::operator=(other);
	return *this;
}

ReturnValue RdsAdObject::sid() const
{
	ReturnValue ret = read(QStringList() << "objectSid");
	if (ret.isError()) return(ret);

	LdapResult result = ret.value<LdapResult>();
	if (!result.contains("objectsid") || (result["objectsid"].count() == 0))
	{
		return(ReturnValue(1, "objectSid attribute does not exist"));
	}

	return(RdsSid(result["objectsid"][0]));
}

ReturnValue RdsAdObject::setSid(const RdsSid &sid)
{
	RdsLdapActions actions;
	actions.addData(RdsLdapActions::Replace, "objectSid", sid.toBinary());

	return(modify(actions));
}

ReturnValue RdsAdObject::securityDescriptor() const
{
	ReturnValue ret = readAttribute("nTSecurityDescriptor");
	if (ret.isError()) return(ret);

	LdapValues values = ret.value<LdapValues>();
	return(QVariant::fromValue(RdsNtSecurityDescriptor(values[0])));
}

ReturnValue RdsAdObject::setSecurityDescriptor(const RdsNtSecurityDescriptor &desc)
{
	RdsLdapActions actions;
	actions.addData(RdsLdapActions::Replace, "nTSecurityDescriptor", desc.toBinary());

	return(modify(actions));
}

ReturnValue RdsAdObject::guid() const
{
	ReturnValue ret = readAttribute("objectGUID");
	if (ret.isError()) return(ret);

	LdapValues values = ret.value<LdapValues>();
	return(QVariant::fromValue(RdsGuid(values[0])));
}

ReturnValue RdsAdObject::setGuid(const RdsGuid &guid)
{
	RdsLdapActions actions;
	actions.addData(RdsLdapActions::Replace, "objectGUID", guid.toBinary());

	return(modify(actions));
}

QDataStream& operator<<(QDataStream& d, const RdsAdObject& object)
{
	d << object.dn();
	return(d);
}

QDataStream& operator>>(QDataStream& d, RdsAdObject& object)
{
	QString dn;
	d >> dn;
	object.setDn(dn);
	return(d);
}

