/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSUSER_H
#define RDSUSER_H

#include <QxtPimpl>
#include <RdsAdObject>
#include <rdsglobal.h>

class RdsUserPrivate;

/**
	@author Brendan Powers <brendan@resara.com>
*/
class RDS_SHARED_EXPORT RdsUser : public RdsAdObject
{
	QXT_DECLARE_PRIVATE(RdsUser);
public:
	enum UserState
	{
		NoState = 0,
		Locked = 1 << 0,
		Disabled = 1 << 1,
		MustChangePassword = 1 << 2,
		CannotChangePassword = 1 << 3,
		PasswordNeverExpires = 1 << 4,
		UseReversibleEncryption = 1 << 5,
		SmartCardRequired = 1 << 6,
		UseDesPassword = 1 << 7,
		NotDelegated = 1 << 8,
		NoPreAuth = 1 << 9
	};
	Q_DECLARE_FLAGS(UserStates, UserState);

	RdsUser();
	RdsUser(const RdsUser &user);
	RdsUser(const QString &dn);
	~RdsUser();
	RdsUser& operator=(const RdsUser &other);

	static ReturnValue createUser(const QString &dn, const QString &account);
	ReturnValue setPassword(const QString &newpw);
	ReturnValue flags() const;
	ReturnValue setFlags(const UserStates &flags);
	ReturnValue setFlag(UserState flag);
	ReturnValue unsetFlag(UserState flag);
	ReturnValue primaryGroup() const;
	ReturnValue setPrimaryGroup(const QString &dn);
	ReturnValue cn() const;
	ReturnValue setCn(const QString &cn);
	ReturnValue groups() const;
	ReturnValue joinGroup(const QString &groupdn);
	ReturnValue leaveGroup(const QString &groupdn);

	//General Info
	ReturnValue userName() const;
	ReturnValue setUserName(const QString &username);
	ReturnValue description() const;
	ReturnValue setDescription(const QString &desc);
	ReturnValue firstName() const;
	ReturnValue setFirstName(const QString &name);
	ReturnValue initials() const;
	ReturnValue setInitials(const QString &initial);
	ReturnValue lastName() const;
	ReturnValue setLastName(const QString &name);
	ReturnValue displayName() const;
	ReturnValue setDisplayName(const QString &name);
	ReturnValue office() const;
	ReturnValue setOffice(const QString &office);
	ReturnValue phoneNumber() const;
	ReturnValue setPhoneNumber(const QString &number);
	ReturnValue email() const;
	ReturnValue setEmail(const QString &mail);
	ReturnValue webPage() const;
	ReturnValue setWebPage(const QString &url);
	ReturnValue street() const;
	ReturnValue setStreet(const QString &street);
	ReturnValue poBox() const;
	ReturnValue setPoBox(const QString &po);
	ReturnValue city() const;
	ReturnValue setCity(const QString &city);
	ReturnValue state() const;
	ReturnValue setState(const QString &state);
	ReturnValue country() const;
	ReturnValue setCountry(const QString &country);
	ReturnValue postalCode() const;
	ReturnValue setPostalCode(const QString &code);
	ReturnValue homeDrive() const;
	ReturnValue setHomeDrive(const QString &drive);
	ReturnValue homePath() const;
	ReturnValue setHomePath(const QString &path);
	ReturnValue profilePath() const;
	ReturnValue setProfilePath(const QString &path);
	ReturnValue logonScript() const;
	ReturnValue setLogonScript(const QString &path);
	ReturnValue pagerNumber() const;
	ReturnValue setPagerNumber(const QString &pager);
	ReturnValue mobileNumber() const;
	ReturnValue setMobileNumber(const QString &number);
	ReturnValue faxNumber() const;
	ReturnValue setFaxNumber(const QString &number);
	ReturnValue homeNumber() const;
	ReturnValue setHomeNumber(const QString &Number);
	ReturnValue notes() const;
	ReturnValue setNotes(const QString &notes);
	ReturnValue title() const;
	ReturnValue setTitle(const QString &title);
	ReturnValue department() const;
	ReturnValue setDepartment(const QString &department);
	ReturnValue company() const;
	ReturnValue setCompany(const QString &company);
	ReturnValue emailAliases();
	ReturnValue setEmailAliases(QStringList aliases);

};

RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsUser& object);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsUser& object);
RDS_SHARED_EXPORT QDataStream& operator<<(QDataStream& d, const RdsUser::UserStates& object);
RDS_SHARED_EXPORT QDataStream& operator>>(QDataStream& d, RdsUser::UserStates& object);
Q_DECLARE_OPERATORS_FOR_FLAGS(RdsUser::UserStates);
Q_DECLARE_METATYPE(RdsUser::UserStates);
Q_DECLARE_METATYPE(RdsUser);

#endif
