/***************************************************************************
 *   Copyright (C) 2009 by Brendan Powers   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RDSJOBTESTER_H
#define RDSJOBTESTER_H

#include <QObject>
#include <RdsJob>

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsJobTester : public QObject
{
	Q_OBJECT;
public:
	RdsJobTester(RdsJob* job);
	~RdsJobTester();

public slots:
	void progressChanged(int percent, const QString& progressText, const QString& progressDetails);
	void statusChanged(RdsJob::Status status);
	void newLogMsg(const QString& line);
	void finished(const ReturnValue& ret);

};

#endif
