/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "rdscomputertester.h"

REGISTER_TEST(RdsComputerTester);

RdsComputerTester::RdsComputerTester(QObject *parent)
		: QObject(parent)
{
}

RdsComputerTester::~RdsComputerTester()
{
}

void RdsComputerTester::initTestCase()
{
	rdsLdapSession()->remove("CN=testgroup,CN=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testperson,CN=Users,dc=resara,dc=local");

	RdsLdapActions act;
	act.add(RdsLdapActions::Add, "objectClass", "computer");
	act.add(RdsLdapActions::Add, "cn", "testperson");
	act.add(RdsLdapActions::Add, "sn", "testperson");
	TEST_FUNCTION(rdsLdapSession()->add("cn=testperson,cn=Users,dc=resara,dc=local", act));

	act.clear();
	act.add(RdsLdapActions::Add, "objectClass", "group");
	act.add(RdsLdapActions::Add, "cn", "testgroup");

	TEST_FUNCTION(rdsLdapSession()->add("CN=testgroup,cn=Users,dc=resara,dc=local", act));
}

void RdsComputerTester::cleanupTestCase()
{
	rdsLdapSession()->remove("CN=compy,CN=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testperson,CN=Users,dc=resara,dc=local");
	rdsLdapSession()->remove("CN=testgroup,CN=Users,dc=resara,dc=local");
}

void RdsComputerTester::constructorTest()
{
	RdsComputer comp;
	RdsComputer compy(comp);

	RdsComputer testcomp1, testcomp2;
	QByteArray ar;
	{
		QDataStream stream(&ar, QIODevice::WriteOnly);
		stream << testcomp1;
	}
	{
		QDataStream stream(ar);
		stream >> testcomp2;
	}
	QCOMPARE(testcomp2.hostName().toString(), testcomp1.hostName().toString());
}

void RdsComputerTester::groupTest()
{
	RdsComputer compy("cn=testperson,cn=Users,dc=resara,dc=local");
	ReturnValue ret = TEST_FUNCTION(compy.groups());
	QStringList list = ret.toStringList();
	QVERIFY2(list.size() == 1, "testperson not member of group cn=Domain Users,cn=Users,dc=resara,dc=local");

	TEST_FUNCTION(compy.joinGroup("CN=testgroup,cn=Users,dc=resara,dc=local"));
	ret = TEST_FUNCTION(compy.groups())
	list = ret.toStringList();
// 	qDebug() << "Groups()" << list.size();
// 	foreach(QString group, list)
// 		qDebug() << group;
	QVERIFY2(list.contains("CN=testgroup,CN=Users,DC=resara,DC=local"), "apears to have not joined the testgroup");

	TEST_FUNCTION(compy.leaveGroup("CN=testgroup,cn=Users,dc=resara,dc=local"));
	ret = TEST_FUNCTION(compy.groups())
	list = ret.toStringList();
/*	qDebug() << "Groups()" << list.size();
	foreach(QString group, list)
		qDebug() << group;*/
	QVERIFY2(!list.contains("CN=testgroup,CN=Users,DC=resara,DC=local"), "apears to have not left the testgroup");

	///try again, changing the cn in between
	ret = TEST_FUNCTION(compy.cn());
	QCOMPARE(ret.toString(), QString("testperson"));
	ret = TEST_FUNCTION(compy.setCn("compy"));
	QCOMPARE(ret.toString(), QString("CN=compy,cn=Users,dc=resara,dc=local"));
	TEST_FUNCTION(compy.setCn("testperson"));

	TEST_FUNCTION(compy.joinGroup("CN=testgroup,cn=Users,dc=resara,dc=local"));
	ret = TEST_FUNCTION(compy.groups())
	list = ret.toStringList();
// 	qDebug() << "Groups()" << list.size();
// 	foreach(QString group, list)
// 		qDebug() << group;
	QVERIFY2(list.contains("CN=testgroup,CN=Users,DC=resara,DC=local"), "apears to have not joined the testgroup");

	TEST_FUNCTION(compy.setCn("compy"));

	TEST_FUNCTION(compy.leaveGroup("CN=testgroup,cn=Users,dc=resara,dc=local"));
	ret = TEST_FUNCTION(compy.groups())
	list = ret.toStringList();
/*	qDebug() << "Groups()" << list.size();
	foreach(QString group, list)
		qDebug() << group;*/
	QVERIFY2(!list.contains("CN=testgroup,CN=Users,DC=resara,DC=local"), "apears to have not left the testgroup");

	TEST_FUNCTION(compy.setCn("testperson"));

	///check primary group
	TEST_FUNCTION(compy.setPrimaryGroup("CN=testgroup,CN=Users,DC=resara,DC=local"));
	ret = TEST_FUNCTION(compy.primaryGroup());
	QCOMPARE(ret.toString(), QString("CN=testgroup,CN=Users,DC=resara,DC=local"));

	TEST_FUNCTION_ERROR(compy.setPrimaryGroup("CN=testperson,CN=Users,DC=resara,DC=local"));
	TEST_FUNCTION_ERROR(compy.setPrimaryGroup("CN=dne,CN=Users,DC=resara,DC=local"));
	TEST_FUNCTION_ERROR(compy.setPrimaryGroup("CN=Administrator,CN=Users,DC=resara,DC=local"));
}

void RdsComputerTester::getSetTest()
{
	RdsComputer compy("cn=testperson,cn=Users,dc=resara,dc=local"), group("CN=testgroup,CN=Users,DC=resara,DC=local");

	TEST_FUNCTION(compy.setDescription("this person is boring"));
	ReturnValue ret = TEST_FUNCTION(compy.description());
	QCOMPARE(ret.toString(), QString("this person is boring"));
	TEST_FUNCTION(compy.setDescription(""));
	ret = TEST_FUNCTION(compy.description());
	QCOMPARE(ret.toString(), QString(""));

	TEST_FUNCTION(group.setNotes("group note"));
	ret = TEST_FUNCTION(group.notes());
	QCOMPARE(ret.toString(), QString("group note"));
	TEST_FUNCTION(group.setNotes(""));
	TEST_FUNCTION_ERROR(group.notes());

	TEST_FUNCTION(compy.setLocation("mars"));
	ret = TEST_FUNCTION(compy.location());
	QCOMPARE(ret.toString(), QString("mars"));
	TEST_FUNCTION(compy.setLocation(""));
	TEST_FUNCTION_ERROR(compy.location());

// 	TEST_FUNCTION(group.setHostName("groupshostname.resara.local"));
// 	ret = TEST_FUNCTION(group.hostName());
// 	QCOMPARE(ret.toString(), QString("groupshostname.resara.local"));
// 	TEST_FUNCTION(group.setHostName(""));
// 	TEST_FUNCTION_ERROR(group.hostName());

	TEST_FUNCTION(compy.setComputerName("compy"));
	ret = TEST_FUNCTION(compy.computerName());
	QCOMPARE(ret.toString(), QString("compy"));
	TEST_FUNCTION_ERROR(compy.setComputerName(""));//sAMAcountName is required.  cannot remove

	TEST_FUNCTION(compy.setOperatingSystem("Linux"));
	ret = TEST_FUNCTION(compy.operatingSystem());
	QCOMPARE(ret.toString(), QString("Linux"));
	TEST_FUNCTION(compy.setOperatingSystem(""));
	TEST_FUNCTION_ERROR(compy.operatingSystem());

	TEST_FUNCTION(compy.setOperatingSystemVersion("Resara"));
	ret = TEST_FUNCTION(compy.operatingSystemVersion());
	QCOMPARE(ret.toString(), QString("Resara"));
	TEST_FUNCTION(compy.setOperatingSystemVersion(""));
	TEST_FUNCTION_ERROR(compy.operatingSystemVersion());

	TEST_FUNCTION(compy.setServicePack("1"));
	ret = TEST_FUNCTION(compy.servicePack());
	QCOMPARE(ret.toString(), QString("1"));
	TEST_FUNCTION(compy.setServicePack(""));
	TEST_FUNCTION_ERROR(compy.servicePack());
}
