/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RDSLDAPSESSIONTESTER_H
#define RDSLDAPSESSIONTESTER_H

#include <QObject>
#include <RdsLdapSession>
#include "rdsdefines.h"
#include "rdstest.h"

/**
	@author ,,, <jchamberlin@devserver>
*/
class RdsLdapSessionTester : public QObject
{
	Q_OBJECT
public:
	RdsLdapSessionTester(QObject *parent = 0);

	~RdsLdapSessionTester();

	RdsLdapSession sesh;
	QString m_basedn;

	bool objContains(const QString &dn, const QString &name, const QString &value);

private slots:
	void initTestCase();
	void init();
	void cleanupTestCase();
#ifdef __RDS_SERVER
	void bindTest();
#endif
	void searchTest();
	void readTest();
	void listTest();
	void addModifyTest();
	void RemoveTest();
	void RenameTest();
	void moveTest();

private:
	ReturnValue ___ret;
};

#endif
