#!/usr/bin/env python

import recoll

db = recoll.connect()
db.setAbstractParams(maxchars=80, contextwords=2)

query = db.query()
nres = query.execute("some user question")
print "Result count: ", nres
if nres > 5:
    nres = 5
while query.next >= 0 and query.next < nres: 
    doc = query.fetchone()
    print query.next
    for k in ("title", "size"):
        print k, ":", getattr(doc, k).encode('utf-8')
    abs = db.makeDocAbstract(doc, query).encode('utf-8')
    print abs
    print


