dnl AC_SEARCH_LIBS_VAR(FUNCTION, SEARCH-LIBS [, ACTION-IF-FOUND
dnl            [, ACTION-IF-NOT-FOUND [, OTHER-LIBRARIES [, VAR]]]])
dnl Search for a library defining FUNC, if it's not already available.
dnl If a library is needed, add it to VAR (typically prog_LDADD) but
dnl not to LIBS

AC_DEFUN([AC_SEARCH_LIBS_VAR],
[AC_PREREQ([2.13])
AC_CACHE_CHECK([for library containing $1], [ac_cv_search_$1],
[ac_func_search_save_LIBS="$LIBS"
ac_cv_search_$1="no"
AC_TRY_LINK_FUNC([$1], [ac_cv_search_$1="none required"])
test "$ac_cv_search_$1" = "no" && for i in $2; do
LIBS="-l$i $5 $ac_func_search_save_LIBS"
AC_TRY_LINK_FUNC([$1],
[ac_cv_search_$1="-l$i"
break])
done
LIBS="$ac_func_search_save_LIBS"])
if test "$ac_cv_search_$1" != "no"; then
  test "$ac_cv_search_$1" = "none required" || $6="$$6 $ac_cv_search_$1"
  $3
else :
  $4
fi])


dnl AC_FUNC_MKFIFO
dnl Test whether mkfifo(const char* pathname, mode_t mode) works
dnl This is necessary to detect Cygwin mkfifo() which is a nonfunctional
dnl stub
AC_DEFUN([AC_FUNC_MKFIFO], [
AC_MSG_CHECKING(for working mkfifo)
AC_TRY_RUN(
changequote(<<, >>)dnl
<<#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
int main(){
int error = 0;
if (mkfifo("test_the_fifo", 0777) != 0) {
error=1;
}
else {
unlink("test_the_fifo");
}
exit (error);
}
>>,
changequote([, ])dnl
ac_cv_func_mkfifo=yes,
ac_cv_func_mkfifo=no,
ac_cv_func_mkfifo=no
)
AC_MSG_RESULT($ac_cv_func_mkfifo)
if test $ac_cv_func_mkfifo = yes ; then
  AC_DEFINE(HAVE_MKFIFO)
fi
])

dnl Check for a required version of Perl.  The separate shell variable and
dnl the changequotes are necessary for autoconf 2.13; autoconf 2.50 will
dnl provide a different interface that will allow this to work correctly.
dnl stolen from Russ Allbery <rra@stanford.edu>
dnl REFDB_PERL_VERSION(perlbin, requiredversion)
AC_DEFUN([REFDB_PERL_VERSION],
[AC_CACHE_CHECK(for Perl version, refdb_perl_version,
[if $1 -e 'require $2;' > /dev/null 2>&1 ; then
    refdb_perl_version=`$1 -e "$refdb_perl_command"`
else
    AC_MSG_WARN(Perl $2 or greater is required for some scripts)
fi])])

dnl Dito, but check for the existence of a Perl module
dnl REFDB_PERL_MODULE(perlbin,modulename,varname)
AC_DEFUN([REFDB_PERL_MODULE],
[AC_CACHE_CHECK(for Perl module $2, $3,
[if $1 -e 'use $2;' > /dev/null 2>&1 ; then
    $3=$2
else
    AC_MSG_WARN(Perl module $2 is required for some scripts)
fi])])

dnl Try to locate a stylesheet using xmlcatalog
AC_DEFUN([REFDB_XML_FILE],
[if test -r /etc/xml/catalog; then
    refdb_xml_catalog="/etc/xml/catalog"
else
    refdb_xml_catalog=$XML_CATALOG_FILES
fi

AC_MSG_CHECKING(for XML file $2)
xml_file=`$1 $refdb_xml_catalog $2`
xml_file=`echo $xml_file | sed 's%file://%%'`
AC_CHECK_FILE($xml_file,[
AC_MSG_RESULT(XML file found)],[
AC_MSG_RESULT(XML file not found, you may wish to check your XML catalog)]
)])
