/* authorinfo.h header file for authorinfo.c */
/* markus@mhoenicka.de 2003-10-03 */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* authorinfo defines an object to fiddle with the parts of an author name */

#ifndef authorinfo_included
#define authorinfo_included 1

/* this structure holds the name components */
struct AUTHOR_INFO {
  char name[256];
  char lastname[256];
  char firstname[256];
  char middlename[256];
  char suffix[256];
  char role[64];
};

char* assemble_full_author(struct AUTHOR_INFO* ptr_ainfo, int* ptr_error);
struct AUTHOR_INFO* new_authorinfo(void);
void reset_authorinfo(struct AUTHOR_INFO* ptr_ainfo);
char* set_authorinfo_name(struct AUTHOR_INFO* ptr_ainfo, const char* name);
char* set_authorinfo_lastname(struct AUTHOR_INFO* ptr_ainfo, const char* lastname);
char* set_authorinfo_firstname(struct AUTHOR_INFO* ptr_ainfo, const char* firstname);
char* add_authorinfo_middlename(struct AUTHOR_INFO* ptr_ainfo, const char* middlename);
char* set_authorinfo_suffix(struct AUTHOR_INFO* ptr_ainfo, const char* suffix);
char* set_authorinfo_role(struct AUTHOR_INFO* ptr_ainfo, const char* role);
void free_authorinfo(struct AUTHOR_INFO* ptr_ainfo);

#endif /* ifndef authorinfo_included */
