/*+++++++++++++++++
  mset.h - header file for mset.c
  markus@mhoenicka.de 2005-12-15

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

#ifndef MSET_H_INCLUDED

#define MSET_H_INCLUDED 1
#define MSET_RELATION_LEN 16
 
typedef struct mset {
  char relation[MSET_RELATION_LEN];      /* relation attribute value of bibliomset */
  int stacksize;
  struct mset *ptr_next;  /* pointer to next element in the list */
} MSET;
  
char* push_mset(struct mset* ptr_first, char* new_mset);
char* pop_mset(struct mset* ptr_first, char* prev_mset);
char* set_mset(struct mset* ptr_first, char* new_mset, char** ref, size_t* ptr_ref_len, const char* ns, struct xmlindent* ptr_indent, int n_ref_format);
struct mset* new_mset_stack(void);
void clear_mset_stack(struct mset* ptr_first);

#endif
