/* refdb.h main include file for the refdb project */
/* markus@mhoenicka.de 2-10-00 */
/* $Id: refdb.h,v 1.14.2.2 2005/11/03 20:40:19 mhoenicka Exp $ */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


#define MAX_FMT_LEN 256 /* maximum length of a getref format string, including the terminating \0 */
#define DBNAME_LENGTH 32 /* maximum database name length (imposed by MySQL) */
#define PRIV_LENGTH 16 /* maximum length of a privilege name in MySQL security
			  tables */
#define PASSWD_LENGTH 16 /* this appears to be the maximum length of a MySQL
			    password */
#define DBUSER_LENGTH 16 /* the maximum database user name length */
#define XMLPARSE_CHUNKSIZE 4096 /* the chunk size when reading an XML file */

/* this accommodates a variable name of max. 16 chars, a tab,
   a POSIX full path, and a \0 (273 = _POSIX_PATH_MAX + 18)*/
#define PREFS_BUF_LEN 273

#ifndef __CYGWIN__
#  if !defined _POSIX_PATH_MAX
#    define _POSIX_PATH_MAX 256 
#  endif
#endif

/* define a few things that should be accessible through libdbi */
#define USERNAME_LENGTH 16
#define HOSTNAME_LENGTH 64

/* these defines are for the getfoo() function */
#define GETAU 0
#define GETKW 1
#define GETJO 2
#define GETJF 3
#define GETJ1 4
#define GETJ2 5
#define GETED 6
#define GETAS 7
#define GETAX 8



