/*+++++++++++++++++++++++
risxhandler.h header file for risxhandler.c
markus@mhoenicka.de 2003-05-13
$Id: risxhandler.h,v 1.10.2.1 2005/08/12 21:10:15 mhoenicka Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ++++++++++++++++++++++++*/

#include "authorinfo.h"
#include "risdata.h"

struct addrisx_data {
  char year[5];
  char month[3];
  char day[3];
  char date_buffer[12];
  char otherinfo[256];
  char username[16]; /* may be different from current user which is in ptr_clrequest */
  struct AUTHOR_INFO* ptr_ainfo;
  struct RISDATA* ptr_risdata;
  char first_author[256];
  char ck_year[5];
  char real_citekey[256];
  char type[7];
  char* msgpool;
  const char* drivername;
  int nmem_error; /* if != 0, out of memory error occurred */
  int ndb_error; /* if != 0, database error occurred */
  int n_skip; /* if != 0, skip current entry element */
  int depth; /* the current depth of the element stack */
  int depth_adjust; /* 0 if entry, 1 if ris */
  unsigned long long set_count; /* number of entry elements */
  unsigned long long added_count; /* number of added entry elements */
  unsigned long long skipped_count; /* number of skipped entries */
  unsigned long long updated_count; /* number of updated entry elements */
  unsigned long long failed_count; /* number of failed entry elements */
  int authorpos;
  int replace_ref; /* if != 0, existing reference is to be replaced */
  int create_new; /* if 1, dataset is a new one */
  size_t msgpool_len;
  unsigned long long n_refdb_id; /* database id of dataset */
  unsigned long long n_user_id; /* database id of current user */
  struct elstack* ptr_first; /* start of the element stack */
  struct PERIODICAL_INFO perinfo; /* periodical name synonyms */
  struct CLIENT_REQUEST* ptr_clrequest; 
  Lilid* ptr_id_sentinel; /* linked list for added IDs */
  dbi_conn conn;
  dbi_conn conn_refdb;
  dbi_driver driver;
  iconv_t conv_descriptor; /* conversion descriptor for iconv */
};

void risx_start_handler(void *ptr_data, const char *el, const char **ptr_attr);

void risx_end_handler(void *ptr_data, const char *el);

void risx_char_handler(void *ptr_data, const char *string, int len);

