/*++++++++
  tokenize.h: header file for tokenize.c
  markus@mhoenicka.de 2-17-00
  $Id: tokenize.h,v 1.5 2003/11/04 23:41:21 mhoenicka Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

struct SQLTOKEN {
  size_t length;
  int type;  /* 0 = text, 1 = logical operator, 2 = opening bracket, */
  char *next_token; /* 3 = closing bracket, 4 = field denominator */
};

struct AUTHORTOKENS {
  char* first;    /* ptr to the first name */
/*   char* middle; */   /* ptr to the middle name */
  Lilistring* ptr_middlelist; /* ptr to linked list with middle names */
  char* sur;      /* ptr to the surname */
  char* lineage;  /* ptr to the lineage */
};

int cmdln_tokenize(int *inargc, char ***ptr_inargv, int inargcmax, char* inbuffer);
char *sql_tokenize(char* inbuffer, struct SQLTOKEN *ptr_sqltoken);
char *link_tokenize(char* inbuffer, struct SQLTOKEN *ptr_sqltoken);
char* nstrtok(char* value, size_t* len, char* delim);
char* ris_strtok(char* value, size_t* len, char* delim);
int string_tokenize(int *inargc, char ***ptr_inargv, int inargcmax, char* inbuffer);
char* tokenize_author(char* authorstring, struct AUTHORTOKENS* ptr_atoken);
void clean_authortokens(struct AUTHORTOKENS* ptr_atoken);
int string_tokenize_lili(Lilid *ptr_first, char *inbuffer);
