/*+++++++++++++++++++++++
xmlhandler.h header file for xmlhandler.c
markus@mhoenicka.de 12-29-00
$Id: xmlhandler.h,v 1.6.2.5 2005/09/29 22:35:59 mhoenicka Exp $

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ++++++++++++++++++++++++*/

#define ELNAME_LENGTH 64     /* max length of an XML element name */
#define ELVALUE_LENGTH 256   /* max/initial length of an XML element value */
#define EL_LENGTH 512   /* ELNAME plus ELVALUE plus a little slack */

/* the current implementation can do without resizable name/value variables which saves a few malloc()/realloc() calls in favour of speed */
struct attrlist {
  char attribute_name[ELNAME_LENGTH];
  char attribute_value[ELVALUE_LENGTH];
  struct attrlist *ptr_next;
};

/* element names are ok with fixed size. element values may be treated
   as resizable */
struct elstack {
  char elname[ELNAME_LENGTH];
  char *ptr_elvalue;
  size_t n_elvalue_len;
  struct attrlist *ptr_attr_first;
  struct elstack *ptr_next;
};

/* this struct defines a simple stack for elements without a length limit for the value and with just one attribute of variable length. */
struct simple_elstack {
  char elname[ELNAME_LENGTH];
  char* elvalue;
  char* attrvalue;
  struct simple_elstack *ptr_snext;
};

struct getbib_data {
  char* ptr_default_db;
  dbi_conn conn; /* connection to the reference database */
  dbi_conn conn_refdb; /* connection to the style database */
  int* ptr_citation_count; /* counter for citations in id handler */
  int* ptr_xref_count; /* counter for xrefs in id handler */
  char* ptr_table_name; /* unique table name for temporary table */
  char* ptr_curr_multi_id; /* ptr to the current multiple citation id */
  char* quoted_journal; /* name of the style to be used */
  size_t* ptr_cmid_len; /* ptr to int containing allocated length of ptr_curr_multi_id */
  int* ptr_nmem_error; /* if != 0, out of memory error occurred */
  int* ptr_ndb_error; /* if != 0, database error occurred */
  unsigned long long* ptr_ndb_notfound; /* number of refs not found in the database */
  struct simple_elstack *ptr_sfirst; /* the elements from the id list */
  struct CLIENT_REQUEST *ptr_clrequest;
  Lilifstring *ptr_notfound_first; /* list of citation keys not found */
  Lilifstring *ptr_found_first; /* list of citation keys found */
};

struct addstyle_data {
  int* ptr_nmem_error; /* if != 0, out of memory error occurred */
  int* ptr_ndb_error; /* if != 0, database error occurred */
  int* ptr_depth; /* the current depth of the element stack */
  int* ptr_depth_adjust; /* 0 if citestyle, 1 if styleset */
  int* ptr_position; /* position of an element in PUBTYPE or INTEXTDEF */
  int* ptr_set_count; /* number of finished CITESTYLE elements */
  unsigned int* ptr_citstyle_id; /* id of the current CITSTYLE element */
  unsigned int* ptr_refstyle_id; /* id of the current REFSTYLE element */
  unsigned int* ptr_separator_id; /* id of the current SEPARATORS element */
  struct elstack* ptr_first; /* start of the element stack */
  char* the_journal; /* current journal name */
  dbi_conn conn;
  struct ADDRESULT* ptr_addresult; /* ptr to struct with counters */
};

void start_handler(void *ptr_data, const char *el, const char **ptr_attr);

void end_handler(void *ptr_data, const char *el);

void char_handler(void *ptr_data, const char *string, int len);

void delete_list(struct elstack* ptr_current_element);

char* get_attr(struct elstack* ptr_current_element, char* attribute);

int is_descendant_of(struct elstack* ptr_current_element, char* ancestor_name);

void id_start_handler(void *ptr_data, const char *el, const char **ptr_attr);

void id_end_handler(void *ptr_data, const char *el);

void id_char_handler(void *ptr_data, const char *string, int len);

void delete_idlist(struct simple_elstack* ptr_current_element);

void idraw_start_handler(void *ptr_data, const char *el, const char **ptr_attr);
void idraw_end_handler(void *ptr_data, const char *el);

void idraw_char_handler(void *ptr_data, const char *string, int len);

