#!/bin/sh


rekallCopyData(){

	opt=$1

	if [ "$opt" = "--rt" ]
	then
		rekallDir=rekallRT
		rekallTag=RT
		desktopTag=rekallrt
	else
		rekallDir=rekall
		rekallTag=
		desktopTag=rekall
	fi

	pythonver=2.2.0
	rekallver=220

	rm -rf	distrib/${rekallDir}
	mkdir	distrib/${rekallDir}
	mkdir	distrib/${rekallDir}/common
	mkdir	distrib/${rekallDir}/common/data
	mkdir	distrib/${rekallDir}/common/data/dict
	mkdir	distrib/${rekallDir}/common/data/script
	mkdir	distrib/${rekallDir}/common/data/script/py
	mkdir	distrib/${rekallDir}/common/data/services
	mkdir	distrib/${rekallDir}/common/data/wizards
	mkdir	distrib/${rekallDir}/common/data/stock
	mkdir	distrib/${rekallDir}/common/data/stock/component
	mkdir	distrib/${rekallDir}/common/data/stock/component/py
	mkdir	distrib/${rekallDir}/common/doc
	mkdir	distrib/${rekallDir}/python
	mkdir	distrib/${rekallDir}/python/Python-${pythonver}-Win

	DLLS="
		kbase${rekallTag}${rekallver}.dll
		kbase_el32.dll
		kbase_common${rekallver}.dll
		kbase${rekallTag}_app${rekallver}.dll
		kbase_wizard${rekallver}.dll
		kbase${rekallTag}_plugin_extra.dll
		kbase_siplib.dll
		kbase_tkkde${rekallver}.dll
		kbase_tkwidgets${rekallver}.dll
		kbase_xbase.dll
		kbase_xbsql.dll
		kbase_driver_mysql.dll
		kbase_driver_pgsql.dll
		kbase_driver_xbase.dll
		"

	for dll in \
		${DLLS}
	do
		echo Copying $dll ...
		cp common/lib/$dll distrib/${rekallDir}
	done

	PARTS="
		kbase${rekallTag}_formview.dll		\
		kbase${rekallTag}_queryview.dll		\
		kbase${rekallTag}_reportview.dll	\
		kbase${rekallTag}_tableview.dll		\
		kbase${rekallTag}_script_py.dll		\
		kbase${rekallTag}_script_pyinterp.dll
		"

	if [ "${rekallTag}" = "" ]
	then
		PARTS="
			${PARTS}			\
			kbase_copierview.dll		\
			kbase_editor.dll		\
			kbase_componentview.dll		\
			kbase_macroview.dll		\
			"
	fi

	for dll in \
		${PARTS}
	do
		echo Copying $dll ...
		cp common/lib/$dll distrib/${rekallDir}
	done

	echo Copying rekall2.exe ...
	cp common/rekall2${rekallTag}.exe distrib/${rekallDir}

	echo Copying additional dlls ...
	cp setup/qt-mt310.dll distrib/${rekallDir}
	cp setup/msvcrt.dll distrib/${rekallDir}
	cp setup/libmmd.dll distrib/${rekallDir}
	cp setup/python22.dll distrib/${rekallDir}
	cp setup/libmySQL.dll distrib/${rekallDir}
	cp setup/libpq.dll distrib/${rekallDir}

	echo Copying UI files ...
	for ui in `cd kbase/ui.std ; echo rekallui.*`
	do
		echo $ui '->' `echo $ui | sed 's/rekallui./rekallui_/'`
		cp kbase/ui.std/$ui distrib/${rekallDir}/common/data/`echo $ui | sed 's/rekallui./rekallui_/'`
	done

	cp script/python/stub/rekallui.pydebug distrib/${rekallDir}/common/data/rekallui_pydebug

	echo Copying desktop files
	for dt in \
		parts/*/${desktopTag}_*.desktop			\
		libs/extra/${desktopTag}_*.desktop		\
		script/python/stub/${desktopTag}_*.desktop
	do
		cp $dt distrib/${rekallDir}/common/data/services
	done
	for db in mysql pgsql xbase
	do
		cp db/$db/rekall_*.desktop distrib/${rekallDir}/common/data/services
	done

	echo Copying dictionary files ...
	cp dict/*.dict distrib/${rekallDir}/common/data/dict
	cp libs/extra/extra.mac distrib/rekall/common/data/dict

	echo Copying wizards files ...
	cp wizards/*.wiz distrib/${rekallDir}/common/data/wizards

	echo Copying help file
	cp doc/rekall/chm/rekall.chm distrib/${rekallDir}/common/doc

	echo Copying editor highlight files ...
	cp -a libs/tkwidgets/highlight distrib/${rekallDir}/common/data

	echo Copying icons ...
	cp -a pics/icons distrib/${rekallDir}/common/data
	cp kbase/rekall.ico distrib/${rekallDir}

	echo Copying pictures ...
	cp -a pics/pics distrib/${rekallDir}/common/data
	cp kbase/rekall.png distrib/${rekallDir}/common/data

	echo Copying scripts ...
	cp script/python/stub/*.py distrib/${rekallDir}/common/data/script/py
	cp parts/table2/*.py distrib/${rekallDir}/common/data/script/py

	echo Copying components
	(
		sd=../../../distrib/${rekallDir}/common/data/stock/component/py

		cd script/python/components.std
		for d in `find * -type d`
		do
			mkdir $sd/$d
		done
		for c in `find * -type f -name '*.cmp'`
		do
			cp $c $sd/$c
		done
		touch	$sd/dummy
	)

	echo Copying license ...
	cp LICENSE distrib/${rekallDir}/common/data

	echo Copying python ...
	cp -a python/Python-${pythonver}-Win distrib/${rekallDir}/python

	echo Odds and sods ...
	cp kbase/keymap distrib/${rekallDir}/common/data

	echo Removing CVS files ...
	find distrib/${rekallDir} -name CVS | xargs rm -rf
}



rekallPackage(){

	rt=$1

	if [ "$opt" = "--rt" ]
	then
		rekallDir=rekallRT
	else
		rekallDir=rekall
	fi

	rm -f	data.z
	/cygdrive/c/Ishield4/PROGRAM/ICOMP.EXE distrib\\${rekallDir}\\\* data.z -i

	rm -rf	package/${rekallDir}
	mkdir	package/${rekallDir}

	(
		cd setup/${rekallDir}
		/cygdrive/c/Ishield4/PROGRAM/COMPILE.EXE setup.rul
	)

	(	cd setup/${rekallDir}
		/cygdrive/c/Ishield4/PROGRAM/PACKLIST.EXE setup.lst
	)

	/cygdrive/c/Ishield4/PROGRAM/SPLIT.EXE -f32000 data.z
	cp data.1   package/${rekallDir}
	cp setup/${rekallDir}/disk1.id  package/${rekallDir}
	cp setup/${rekallDir}/setup.ins package/${rekallDir}
	cp setup/${rekallDir}/setup.pkg package/${rekallDir}
	cp /cygdrive/c/Ishield4/PROGRAM/setup.exe	package/${rekallDir}
	cp /cygdrive/c/Ishield4/PROGRAM/UNINST.EXE	package/${rekallDir}
	cp /cygdrive/c/Ishield4/PROGRAM/_INST32I.EX_	package/${rekallDir}
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.DLL	package/${rekallDir}
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.LIB	package/${rekallDir}
	cp /cygdrive/c/Ishield4/PROGRAM/_ISDEL.EXE	package/${rekallDir}
}

odbcCopyData(){

	rm -rf	distrib/odbc
	mkdir	distrib/odbc
	mkdir	distrib/odbc/common
	mkdir	distrib/odbc/common/data
	mkdir	distrib/odbc/common/data/services

	for dll in	\
		kbase_driver_odbc.dll
	do
		echo Copying $dll ...
		cp common/lib/$dll distrib/odbc
	done

	echo Copying desktop files
	for db in odbc
	do
		cp db/$db/rekall_*.desktop distrib/odbc/common/data/services
	done

	echo Removing CVS files ...
	find distrib/odbc -name CVS | xargs rm -rf
}


odbcPackage(){

	rm -f	data.z
	/cygdrive/c/Ishield4/PROGRAM/ICOMP.EXE 'distrib\odbc\*' data.z -i

	rm -rf	package/odbc
	mkdir	package/odbc

	(
		cd setup/odbc
		/cygdrive/c/Ishield4/PROGRAM/COMPILE.EXE setup.rul
	)

	(	cd setup/odbc
		/cygdrive/c/Ishield4/PROGRAM/PACKLIST.EXE setup.lst
	)

	/cygdrive/c/Ishield4/PROGRAM/SPLIT.EXE -f32000 data.z
	cp data.1   package/odbc
	cp setup/odbc/disk1.id  package/odbc
	cp setup/odbc/setup.ins package/odbc
	cp setup/odbc/setup.pkg package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/setup.exe	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/UNINST.EXE	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_INST32I.EX_	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.DLL	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.LIB	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_ISDEL.EXE	package/odbc
}

mkdir -p distrib
mkdir -p package

rekallCopyData
rekallPackage

rekallCopyData --rt
rekallPackage --rt

odbcCopyData
odbcPackage

echo Done
