<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="//sect3[starts-with(@id, 'help_')]">
<help>
<legend><xsl:value-of select="@legend"/></legend>
<qt>
<xsl:apply-templates/>
</qt>
</help>
</xsl:template>

<xsl:template match="//sect2[starts-with(@id, 'help_')]">
<help>
<legend><xsl:value-of select="@legend"/></legend>
<qt>
<xsl:apply-templates/>
</qt>
</help>
</xsl:template>

<xsl:template match="//para [starts-with(@id, 'help_') and @title]">
<help>
<legend><xsl:value-of select="@legend"/></legend>
<qt>
<h2><font color="#FF0000"><xsl:value-of select="@title"/></font></h2>
<p>
<xsl:apply-templates/>
</p>
</qt>
</help>
</xsl:template>

<xsl:template match="//para [starts-with(@id, 'help_')]">
<help>
<legend><xsl:value-of select="@legend"/></legend>
<qt>
<xsl:apply-templates/>
</qt>
</help>
</xsl:template>

<xsl:template match="title">
<h2><font color="#FF0000"><xsl:apply-templates/></font></h2>
</xsl:template>

<xsl:template match="para">
<p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="emphasis">
<i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="itemizedlist">
<ul><xsl:apply-templates/></ul>
</xsl:template>

<xsl:template match="listitem">
<li><xsl:apply-templates/></li>
</xsl:template>

<xsl:template match="programlisting">
<pre><font color="#004000"><xsl:apply-templates/></font></pre>
</xsl:template>

<xsl:template match="previous">
<xsl:variable name="href">
<xsl:value-of select="@tag"/>
</xsl:variable>
<br/><a href="{$href}"><xsl:value-of select="@title"/></a>
</xsl:template>

<xsl:template match="next">
<xsl:variable name="href">
<xsl:value-of select="@tag"/>
</xsl:variable>
<br/><a href="{$href}"><xsl:value-of select="@title"/></a>
</xsl:template>

<xsl:template match="informaltable">
<table>
<xsl:apply-templates/>
</table>
</xsl:template>

<xsl:template match="tgroup">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="colspec">
</xsl:template>

<xsl:template match="tbody">
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="row">
<tr>
<xsl:apply-templates/>
</tr>
</xsl:template>

<xsl:template match="entry">
<td>
<xsl:apply-templates/>
</td>
</xsl:template>

</xsl:stylesheet>
