/***************************************************************************
    file	         : kb_dbdlg_desktop.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#include	<qlistview.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_listitem.h"
#include	"kb_dbdlg.h"
#include	"kb_dbinfo.h"
#include	"kb_serverdlg.h"
#include	"kb_script.h"
#include	"kb_scriptlist.h"
#include	"kb_viewer.h"
#include	"kb_desktop.h"

#include	"kb_libloader.h"

struct	PluginItem
{
	KBFileList	*list	;
	QString		name	;
	QString		icon	;
}	;

#define	MAXPLUG	64
#define	NUMPLUG	128

typedef	void	*(*IFPROC)()	;

extern	void	registerLanguage (const QString &) ;
extern	void	registerScript	 (const QString &, KBFactory *) ;

#if		__KB_RUNTIME
#define		DTPREFIX	"rekallrt"
#define		DTTYPE		"RekallRT/Part"
#else
#define		DTPREFIX	"rekall"
#define		DTTYPE		"Rekall/Part"
#endif

/*  KBDBaseDlg								*/
/*  loadParts	: Load component parts					*/
/*  minSize	: QSize &	: For minimum dialog size		*/
/*  (returns)	: void		:					*/

void	KBDBaseDlg::loadParts
	(	QSize	&minSize
	)
{
	KBLibLoader	*loader	= KBLibLoader::self () ;

	/* Scan the local desktop files which descrive the rekall	*/
	/* "services". These are the same files as used for the KTrader	*/
	/* version, but the decoding in KBDesktop is much simplified.	*/
	QString		 dtDir	= locateDir
				  (	"appdata",
					"services/rekall_dummy.desktop"
				  )	;
	uint idx;

	QList<KBDesktop> dtDefs		;
	PluginItem	 items[NUMPLUG] ;

	KBDesktop::scan (dtDir + "/services", DTPREFIX "_", dtDefs) ;

	for (idx = 0 ; idx < NUMPLUG ; idx += 1)
		items[idx].list = 0 ;


	for (idx = 0 ; idx < dtDefs.count() ; idx += 1)
	{
		KBDesktop *desktop = dtDefs.at(idx) ;

		// desktop->print () ;

		if (desktop->property ("ServiceTypes") != DTTYPE)
			continue	;


		QString	libname	 = desktop->property("X-KDE-Library") ;
		QString	partType = desktop->property("X-KDE-RekallPart-PartType"   ) ;
		QString	partExtn = desktop->property("X-KDE-RekallPart-PartExtn"   ) ;
		QString	objType	 = desktop->property("X-KDE-RekallPart-ObjectType" ) ;
		QString	hidden	 = desktop->property("X-KDE-RekallPart-Hidden"	   ) ;
		QString	icon	 = desktop->property("Icon") ;

		if (libname.isEmpty())
		{
			/* If there is no library name then register	*/
			/* part information anyway. This handle objects	*/
			/* (such as copiers) than are used in the	*/
			/* runtime version but accessed as parts.	*/
			KBLocation::registerType
			(	partType,
				partExtn,
				objType,
				0
			)	;

			continue ;
		}

		KBLibrary *lib 	 = loader->getLibrary (libname) ;
		if (lib == 0)
		{
			fprintf
			(	stderr,
				"KBDBDlg::loadParts: %s: %s\n",
				(cchar *)libname,
				(cchar *)loader->lastErrorMessage()
			)	;
			continue;
		}

		KBPartFactory	*factory = (KBPartFactory *)lib->factory() ;
		if (factory == 0)
		{	
			fprintf	(stderr, "KBDBDlg: cannot create factory %s\n", (cchar *)libname) ;
			continue  ;
		}

		addIdentString (objType, factory->ident()) ;

		/* Register the type and extension, along with the part	*/
		/* factory, with the location class.			*/
		KBLocation::registerType
		(	partType,
			partExtn,
			objType,
			factory
		)	;

		/* In the runtime, we do not show tabs for parts such	*/
		/* as tables or for queries, although the parts are	*/
		/* still registered in order for the openTable and	*/
		/* openQuery methods to work. This is handled by the	*/
		/* hidden property.					*/
		if (hidden == "Yes") continue ;


		KBFileList *list = (KBFileList *)factory->create(this, (cchar *)dbInfo, "browser") ;
		if (list == 0)
		{
			fprintf	(stderr, "KBDBDlg: cannot create browser %s\n", (cchar *)libname) ;
			continue ;
		}

		/* OK, got a part build. Add to the item list at the	*/
		/* specified slot (or as close thereafter.		*/
		QString	name	= desktop->property("X-KDE-RekallPart-DisplayName") ;
		uint	slot	= desktop->property("X-KDE-RekallPart-DisplaySlot").toUInt() ;

		if (slot >= MAXPLUG) slot = MAXPLUG ;
		while ((slot < NUMPLUG - 1) && (items[slot].list != 0))
			slot += 1 ;

		PluginItem &item = items[slot] ;
		item.list    = list	;
		item.name    = name	;
		item.icon    = icon	;
	}


	/* Now that we have all the parts, add tab pages for them in	*/
	/* the slot order.						*/
	for (idx = 0 ; idx < NUMPLUG ; idx += 1)
		if (items[idx].list != 0)
		{	PluginItem &item = items[idx] ;
			addPage		(item.list, TR(item.name), item.icon) ;
			fileDict.insert (TR(item.name), item.list) ;
			minSize	= minSize.expandedTo (item.list->minimumSizeHint()) ;
		}


	/* Now similarly look for all scripting languages. There is no	*/
	/* ordering on these (maybe is should be done by language name)	*/
	/* Here we use a fixed list type for all languages.		*/
	for (idx = 0 ; idx < dtDefs.count() ; idx += 1)
	{
		KBDesktop *desktop = dtDefs.at(idx) ;

		// desktop->print () ;

		if (desktop->property ("ServiceTypes") != "Rekall/Script")
			continue	;

		QString	libname	 = desktop->property("X-KDE-Library") ;
		if (libname.isEmpty()) continue ;

		KBLibrary *lib 	 = loader->getLibrary (libname) ;
		if (lib == 0)
		{
			fprintf
			(	stderr,
				"KBDBDlg::loadParts: %s: %s\n",
				(cchar *)libname,
				(cchar *)loader->lastErrorMessage()
			)	;
			continue;
		}

		KBFactory *factory = (KBFactory *)lib->factory () ;
		if (factory ==  0)
		{	
			fprintf	(stderr, "KBDBDlg: cannot create %s\n", (cchar *)libname) ;
			continue  ;
		}

		QString	lang	= desktop->property("X-KDE-RekallPart-Language") ;

#if	! __KB_RUNTIME
		QString	legend  = QString(TR("Scripts: %1")).arg(lang) ;
		fprintf	(stderr, "Lang: %s\n", (cchar *)lang) ;

		KBScriptList *slst = new KBScriptList (this, dbInfo, lang) ;
		scriptDict.insert (legend, slst) ;
		addPage (slst, QString("Scripts: %1").arg(lang), "script") ;
		minSize	= minSize.expandedTo (slst->minimumSizeHint()) ;
#endif
		registerLanguage (lang) ;
		registerScript	 (lang, factory) ;
	}
}
