/***************************************************************************
    file	         : kb_qryparser.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	 _KB_QRYPARSER_H
#define	 _KB_QRYPARSER_H


#include	<qstring.h>
#include	<qstringlist.h>

#include 	"kb_classes.h"
#include 	"kb_select.h"


/*  KBQryParser								*/
/*  -----------								*/
/*  Basic parser for SQL select queries. This is used to split up	*/
/*  queries in the raw SQL query and in the query logger. It is not a	*/
/*  full parser, for instance expressions are parsed as arbitrary	*/
/*  non-keyword sequences separated by commas.				*/

class KBQryParser
{
	KBSelect	&m_select	;

	QString		m_error		;
	QString		m_buffer	;
	uint		m_buffPtr	;
	QString		m_token		;
	QString		m_white		;

	void		addSelectExpr	(const QString &) ;
	void		addSelectWhere	(const QString &) ;
	void		addSelectGroup	(const QString &) ;
	void		addSelectHaving	(const QString &) ;
	void		addSelectOrder	(const QString &) ;

	void		setError	(const QString &) ;

	bool		nextToken	()	;
	bool		isKeyword	()	;
	QString		parseExpr	(bool, bool) ;
	void		parseExprList	(void (KBQryParser::*)(const QString &), cchar *, bool) ;
	bool		parseTableList	()	;

public	:

	KBQryParser	(KBSelect &) ;

	bool		parseQuery	(const QString &) ;

	inline	const	QString	&lastError ()
	{
		return	m_error	;
	}

/*	inline QString	getPrettyText ()
	{
		return	m_select.getPrettyText (false) ;
	}*/
}	;

#endif	// _KB_QRYPARSER_H
