/***************************************************************************
    file	         : kb_serverdata.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_SERVERDATA_H
#define	__KB_SERVERDATA_H


#include	<qguardedptr.h>

#include	"kb_serverinfo.h"
#include	"kb_dbinfo.h"
#include	"kb_rawsql.h"


/*  KBServerData							*/
/*  ------------							*/
/*  This class is a wrapper around the KBServerInfo class, which	*/
/*  implements the user/password prompt and make rekall tables user	*/
/*  queries for rekall, hence moving these GUI dependant functions out	*/
/*  of the driver library.						*/

class	KBServerData : public KBServerInfo
{
	QGuardedPtr<KBRawSQL>	m_rawSQL	;

protected :

	virtual	bool	promptUserPassword	(KBError &) ;
	virtual	bool	promptMakeObjTable	() ;
	virtual	bool	promptMakeDesignDict	() ;

public	:

	KBServerData (KBDBInfo *)	;
	KBServerData (KBDBInfo *, const KBServerInfo *) ;
	KBServerData (KBDBInfo *, cchar  *) ;
	KBServerData (KBDBInfo *, const QDomElement  &) ;

	KBServerData
	(	KBDBInfo *,
		cchar    *, cchar  *, cchar  *,
		cchar    *, cchar  *, cchar  *
	)	;

	virtual	~KBServerData () ;

	void		showRawSQL		(KBaseApp *) ;
}	;


/*  KBDBInfoData							*/
/*  ------------							*/
/*  Similarly, a wrapper for the KBDBInfo class, used so that instances	*/
/*  of KBServerData are created rather than the base KBServerInfo.	*/

class	KBDBInfoData : public KBDBInfo
{
protected :

	virtual	KBServerInfo	*newServerInfo	()		      ;
	virtual	KBServerInfo	*newServerInfo	(const QString	   &) ;
	virtual	KBServerInfo	*newServerInfo	(const QDomElement &) ;

public	:

	KBDBInfoData (const QString &)	;
	virtual	 ~KBDBInfoData () ;

	KBServerData		*findServer	(const QString	   &) ;
}	;

#endif	// __KB_SERVERDATA_H
