/***************************************************************************
    file	         : kb_textlog.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_TEXTLOG_H
#define  _KB_TEXTLOG_H


#include	<qtextview.h>

#include	"kb_classes.h"
#include	"kb_part.h"

/*  KBTextLog								*/
/*  ---------								*/
/*  This class provides a simple text logging window, where the number	*/
/*  of lines of text is limited to some value, and new lines are	*/
/*  appended at the end. It uses a QTextView to do the display so that	*/
/*  the RTF features can be used.					*/

class	KBTextLog : public KBasePart
{
	Q_OBJECT

	QTextView	*log	;	/* Text display widget		*/
	uint		minln	;	/* Minimum lines to show	*/
	uint		maxln	;	/* Maximum lines to show	*/
	int		lspace	;	/* Line spacing in pixels	*/
	QList<QString>	lines	;	/* Current set of lines		*/
	KBaseGUI	*gui	;	/* GUI for this window		*/
	TKToggleAction	*action	;	/* GUI show/hide action		*/

public	:

		 KBTextLog (QWidget *, cchar *, TKToggleAction *) ;
	virtual	~KBTextLog () ;

	virtual	void	cleanup	   () {} ;
	virtual	void	hide	   () ;
	virtual	bool	closeEvent () ;
	virtual	void	resizeEvent(QResizeEvent *) ;

	void		logText    (const QString &, bool) ;
}	;

#endif // _KB_TEXTLOG_H
