/***************************************************************************
    file	         : kb_dbdlg_qlib.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_port_loader.h"
#include	"kb_port_gui.h"
#include	"kb_dbdlg.h"
#include	"kb_scriptlist.h"
#include	"kb_desktop.h"


#if		__KB_QLIB


#if		__KB_EMBEDDED
#include	<qpe/qlibrary.h>
#else
#include 	<qlibrary.h>
#endif

#include <qmessagebox.h>

typedef	void	*(*IFPROC)()	;

struct	PluginSpec
{
	cchar		*libName	;
	cchar		*displayName	;
	cchar		*partType	;
	cchar		*partExtn	;
	cchar		*objectType	;
}	;

struct	ScriptSpec
{
	cchar		*libName	;
	cchar		*language	;
}	;

static	PluginSpec pluginList[] =
{
	{	"tableview",
		"Tables",
		"table",
		"tbl",
		"Table"
	},
	{	"formview",
		"Forms",
		"form",
		"frm",
		"Form"
	},
	{	"reportview",
		"Reports",
		"report",
		"rep",
		"Report"
	},
	{	"queryview",
		"Queries",
		"query",
		"qry",
		"Query"
	},
	{	"copierview",
		"Copy",
		"copier",
		"cpy",
		"Copier"
	},
	{	"editor",
		"Editor",
		"script",
		"",
		"Editor"
	},
	{	"componentview",
		"Components",
		"component",
		"cmp",
		"Component"
	},
	{	0,
		0,
		0,
		0,
		0
	}
}	;

static	ScriptSpec scriptList[] =
{
	{	"script_py",
		"py"
	},
	{	0,
		0
	}
}	;

extern	void	registerLanguage (const QString &) ;
extern	void	registerScript	 (const QString &,  KBFactory *) ;

extern	QString locateFile	 (const char *, const QString &) ;
extern	QString locateDir	 (const char *, const QString &) ;

/*  ------------------------------------------------------------------  */

/*  KBDBaseDlg								*/
/*  loadParts	: Load component parts					*/
/*  minSize	: QSize &	: For minimum dialog size		*/
/*  (returns)	: void		:					*/

void	KBDBaseDlg::loadParts
	(	QSize	&minSize
	)
{
	for (PluginSpec *ps = &pluginList[0] ; ps->libName != 0 ; ps += 1)
	{

#if	__KB_EMBEDDED
		QLibrary *lib 	= new QLibrary
				  (	QString("kbase_%1").arg(ps->libName),
					QLibrary::Immediately
				  )	;
#else
		QLibrary *lib 	= new QLibrary
				  (	QString("kbase_%1").arg(ps->libName)
				  )	;
#endif

//		if (!lib->isLoaded())
//		{	
//			fprintf	(stderr, "KBDBDlg: cannot load %s\n",   ps->displayName) ;
//			continue  ;
//		}

		IFPROC	 ifproc = (IFPROC) lib->resolve (QString("init_libkbase_%1").arg(ps->libName)) ;
		if (ifproc ==  0)
		{	
			fprintf	(stderr, "KBDBDlg: no interface %s\n",  ps->displayName) ;
			continue  ;
		}

		KBPartFactory *factory = (KBPartFactory *)(*ifproc)() ;
		if (factory ==  0)
		{	
			fprintf	(stderr, "KBDBDlg: cannot create %s\n", ps->displayName) ;
			continue  ;
		}

		/* Register the type and extension, along with the part	*/
		/* factory, with the location class.			*/
		KBLocation::registerType
		(	ps->partType,
			ps->partExtn,
			ps->objectType,
			factory
		)	;

		KBFileList *list = (KBFileList *)factory->create(this, (cchar *)dbInfo, "browser") ;
		if (list != 0)
		{
			addPage	  (list, TR(ps->displayName)) ;
			fileDict.insert (TR(ps->displayName), list)   ;
			minSize	= minSize.expandedTo (list->minimumSizeHint()) ;
		}

	}

	for (ScriptSpec *ss = &scriptList[0] ; ss->libName != 0 ; ss += 1)
	{
#if	__KB_EMBEDDED
		QLibrary *lib   = new QLibrary
				  (	QString("kbase_%1").arg(ss->libName),
					QLibrary::Immediately
				  )	;
#else
		QLibrary *lib   = new QLibrary
				  (	QString("kbase_%1").arg(ss->libName)
				  )	;
#endif
		if (lib ==  0)
		{
			fprintf	(stderr, "KBDBDlg: cannot load %s\n",   ss->language) ;
			continue  ;
		}

		IFPROC	 ifproc = (IFPROC) lib->resolve (QString("init_libkbase_%1").arg(ss->libName)) ;
		if (ifproc ==  0)
		{
			fprintf	(stderr, "KBDBDlg: no interface %s\n",  ss->language) ;
			continue  ;
		}

		KBFactory *factory = (KBFactory *)(*ifproc)() ;
		if (factory ==  0)
		{
			fprintf	(stderr, "KBDBDlg: cannot create %s\n", ss->language) ;
			continue  ;
		}

		QString	lang	= ss->language ;
		QString	legend  = QString(TR("Scripts: %1")).arg(lang) ;
		fprintf	(stderr, "Lang: %s\n", (cchar *)lang) ;

		KBScriptList *slst = new KBScriptList (this, dbInfo, lang) ;
		scriptDict.insert (lang, slst) ;

		addPage  (slst, legend) ;
		minSize	= minSize.expandedTo (slst->minimumSizeHint()) ;

		registerLanguage (lang) ;
		registerScript	 (lang, factory) ;
	}
}

#endif	// __KB_QLIB
