/***************************************************************************
    file	         : kb_director.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdlib.h>
#include	<qapplication.h>
#include	<qmessagebox.h>

#include	"kbase.h"

#ifndef 	_WIN32
#include	"kb_director.moc"
#else
#include	"kb_director.h"
#include	<htmlhelp.h>
#endif


#if		QT_VERSION >= 300
#include	<qprocess.h>
#endif


extern	QString 	locateFile	(const char *, const QString &) ;
extern	const QString	&getRootDir	() ;
extern	void		setActiveWindow	(QWidget *) ;
extern	void		dropActiveWindow(QWidget *) ;

/*  KBDirector								*/
/*  getKBaseApp	: Get currently active application			*/
/*  (returns)	: KBaseApp *	: Current or null if none		*/

KBaseApp
	*KBDirector::getKBaseApp ()
{
#if	__KB_EMBEDDED
	extern	KBaseApp *kbaseApp ;
	return	kbaseApp ;
#else
	QWidget	*active	= qApp->activeWindow() ;
	if ((active != 0) && active->inherits ("KBaseApp"))
		return	(KBaseApp *)active ;
	return	0 ;
#endif
}

/*  KBDirector								*/
/*  openRecent	: Open recent database					*/
/*  (returns)	: void		:					*/

void	KBDirector::openRecent
	(	const	TKURL	&url
	)
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->openRecent (url) ;
}

/*  KBDirector								*/
/*  openDatabase: Open database						*/
/*  (returns)	: void		:					*/

void	KBDirector::openDatabase ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->openDatabase () ;
}

/*  KBDirector								*/
/*  showQueryLog: Hide or show the query log window			*/
/*  (returns)	: void		:					*/

void	KBDirector::showQueryLog ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showQueryLog () ;
}

/*  KBDirector								*/
/*  showEventLog: Hide or show the event log window			*/
/*  (returns)	: void		:					*/

void	KBDirector::showEventLog ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showEventLog () ;
}

/*  KBDirector								*/
/*  showScriptLog: Hide or show the script log window			*/
/*  (returns)	 : void		:					*/

void	KBDirector::showScriptLog ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showScriptLog () ;
}

/*  KBDirector								*/
/*  showDebugger : Show debugger					*/
/*  (returns)	 : void		:					*/

void	KBDirector::showDebugger ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showDebugger () ;
}

/*  KBDirector								*/
/*  playScore 	: Replay a score					*/
/*  (returns)	: void		:					*/

void	KBDirector::playScore ()
{
	KBaseApp *app = getKBaseApp  () ;
	if (app != 0) app->playScore () ;
}

/*  KBDirector								*/
/*  package	: Page database						*/
/*  (returns)	: void		:					*/

void	KBDirector::package ()
{
	KBaseApp *app = getKBaseApp  () ;
	if (app != 0) app->package   () ;
}

/*  KBDirector								*/
/*  newDatabase	: Create a mew database					*/
/*  (returns)	: void		:					*/

void	KBDirector::newDatabase ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->newDatabase () ;
}

/*  KBDirector	:							*/
/*  showOptions	: Show global options dialog				*/
/*  (returns)	: void		:					*/

void	KBDirector::showOptions ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showOptions () ;
}

/*  KBDirector	:							*/
/*  quit	: Quit/close database window				*/
/*  (returns)	: void		:					*/

void	KBDirector::quit ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->close () ;
}


/*  KBDirector	:							*/
/*  showHelpContents							*/
/*		: SHow help at contents page				*/
/*  (returns)	: void		:					*/

void	KBDirector::showHelpContents ()
{
#ifdef	_WIN32

	QString	  helpStr = getRootDir() + "\\doc\\rekall.chm::/index.html" ;
	fprintf
	(	stderr,
		"KBDirector::showHelpContents(%s)\n",
		(cchar *)helpStr
	)	;

	HtmlHelpA (GetDesktopWindow(), helpStr, HH_DISPLAY_TOC, NULL) ;
#else

#if	__KB_TKC && ! __KB_EMBEDDED

	QProcess  *process ;
	QString	  docroot  = locateFile ("doc", "index.html") ;

	process	= new QProcess(this) ;
	process->addArgument  ("konqueror") ;
	process->addArgument  (docroot	  ) ;
	if (process->start()) return ;

	delete	process ;

	process = new QProcess(this) ;
	process->addArgument  ("netscape" ) ;
	process->addArgument  (docroot	  ) ;
	if (process->start()) return ;

	delete	process	;

	QMessageBox::warning
	(	0,
		"Rekall",
		TR("Failed to execute browser from any of the usual places."),
		QMessageBox::Ok,
		QMessageBox::NoButton,
		QMessageBox::NoButton
	)	;
#endif
#endif
}

void	KBDirector::showHelpIndex  ()
{
#ifdef	_WIN32
	QString	  helpStr = getRootDir() + "\\doc\\rekall.chm::/index.html" ;
	fprintf
	(	stderr,
		"KBDirector::showHelpIndex(%s)\n",
		(cchar *)helpStr
	)	;

	HtmlHelpA (GetDesktopWindow(), helpStr, HH_DISPLAY_INDEX, NULL) ;
#endif
}

void	KBDirector::showHelpSearch ()
{
#ifdef	_WIN32
	HH_FTS_QUERY q;
	q.cbStruct	  = sizeof(HH_FTS_QUERY);
	q.fUniCodeStrings = false		;
	q.pszSearchQuery  = L""			;
	q.iProximity 	  = 0			;
	q.fStemmedSearch  = false		;
	q.fTitleOnly	  = false		;
	q.fExecute	  = false		;
	q.pszWindow	  = L"rekallHelp"	;

	QString	  helpStr = getRootDir() + "\\doc\\rekall.chm::/index.html" ;
	fprintf
	(	stderr,
		"KBDirector::showHelpSearch(%s)\n",
		(cchar *)helpStr
	)	;

	HtmlHelpA (GetDesktopWindow(), helpStr, HH_DISPLAY_SEARCH, (DWORD)&q) ;
#endif
}

void	KBDirector::showHelpAbout ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showAboutApplication () ;
}

void	KBDirector::showHelpPlugins ()
{
	KBaseApp *app = getKBaseApp () ;
	if (app != 0) app->showAboutDialog (true) ;
}

/*  ------------------------------------------------------------------  */

/*  KBDirector								*/
/*  showWindowList: Show list of windows				*/
/*  (returns)	  : void	:					*/

void	KBDirector::loadWindowList ()
{
	/* This method is hooked to the "aboutToShow" event of the	*/
	/* select actions popup menu. We use it to load the window list	*/
	/* on the fly.							*/
	extern	TKSelectAction	*actShowWindow	;
	QStringList		entries		;

	m_windowDict.clear() ;

	LITER
	(	KBasePart,
		m_partList,
		part,

		QWidget	*window	= part->getMainWindow () ;
		if (window == 0) window   = part->getPartWidget () ;
		if (window == 0) continue ;

		/* No not show database windows, these appear in the	*/
		/* separate database menu (and not at all in the	*/
		/* runtime version).					*/
		if (part->isA("KBDBaseViewer")) continue ;

		QString	caption	= window->caption ()	;
		int	idx	= caption.findRev ('-') ;
		if (idx >= 0) caption = caption.left (idx) ;

		entries     .append (caption) ;
		m_windowDict.insert (caption, window) ;
	)

	actShowWindow->setItems (entries) ;
}

/*  KBDirector								*/
/*  addPart	: Add a part to the window list				*/
/*  part	: KBasePart *	: Part in question			*/
/*  (returns)	: void		:					*/

void	KBDirector::addPart
	(	KBasePart	*part
	)
{
	fprintf
	(	stderr,
		"KBDirector::addPart [%p][%s]\n",
		(void *)part,
		part  ->className()
	)	;
	m_partList.append (part) ;

	connect
	(	part,
		SIGNAL(destroyed()),
		this,
		SLOT  (partGone ())
	)	;
}

/*  KBDirector								*/
/*  dropPart	: Drop a part to the window list			*/
/*  part	: KBasePart *	: Part in question			*/
/*  (returns)	: void		:					*/

void	KBDirector::dropPart
	(	KBasePart	*part
	)
{
	fprintf	(stderr, "KBDirector::dropPart [%p]\n", (void *)part) ;

	disconnect
	(	part,
		SIGNAL(destroyed()),
		this,
		SLOT  (partGone ())
	)	;

	m_partList.removeRef (part) ;
	::dropActiveWindow   (part->getMainWindow()) ;

}

/*  KBDirector								*/
/*  alterPart	: Alter part details					*/
/*  part	: KBasePart *	: Part in question			*/
/*  (returns)	: void		:					*/

void	KBDirector::alterPart
	(	KBasePart	*
	)
{
	/* Menu is constructed on the fly, so this is a null operation.	*/
}

/*  KBDirector								*/
/*  showWindow	: Show a window						*/
/*  text	: const QString & : Text from menu			*/
/*  (returns)	: void		:					*/

void	KBDirector::showWindow
	(	const QString	&text
	)
{
	QWidget	*window	= m_windowDict.find (text) ;

	fprintf
	(	stderr,
		"KBDirector::showWindow(%s) -> %p\n",
		(cchar *)text,
		(void  *)window
	)	;

	if (window != 0)
	{
		window->show	        () ;
		window->raise	        () ;
		window->setActiveWindow () ;
		::setActiveWindow	(window) ;
	}
}

void	KBDirector::partGone ()
{
	dropPart ((KBasePart *)sender()) ;
}

