/***************************************************************************
    file	         : kb_rawsql.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_RAWSQL_H
#define	__KB_RAWSQL_H

#include	<qsplitter.h>
#include	<qwidgetstack.h>
#include	<qlayout.h>
#include	<qtextview.h>
#include	<qlistview.h>
#include	<qtabwidget.h>

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_part.h"

#include	"tktextmanager.h"
#include	"tktexteditor.h"

#include	"tkc_tkemapper.h"

#include	"tk_config.h"


class	KBRawSQL	;
class	KBRawSQLPage	;


/*  KBRawSQLPage							*/
/*  ------------							*/
/*  This class is used for each query page displayed. It handles both	*/
/*  the text editor used to enter a query (and which is a tab of the	*/
/*  tab widget) and the widget used to display results).		*/

class	KBRawSQLPage : public TKTextEditor
{
	Q_OBJECT

	KBRawSQL	*m_rawSQL	;
	QString		m_caption	;

	QTextView	*m_textView	;
	QListView	*m_listView	;

	void		cleanPage	() ;
	void		showText	(const QString &) ;
	void		showSelect	(KBSQLSelect   *) ;
	void		executeCommand	(const QString &) ;
	void		executeSelect	(const QString &) ;
	void		executeUpdate	(const QString &, const QString &) ;
	void		executeInsert	(const QString &, const QString &) ;
	void		executeDelete	(const QString &, const QString &) ;

protected slots :

	void		slotTabChanged	(QWidget   *) ;

public	:

	KBRawSQLPage
	(	KBRawSQL	*,
		const QString	&,
		const QString	& = QString::null
	)	;
       ~KBRawSQLPage	() ;

	void		execute		()	;
	void		save		(TKConfig *, uint) ;
	void		setCaption	(const QString  &) ;
}	;


/*  KBRawSQL								*/
/*  --------								*/
/*  Raw SQL execution and display class.				*/

class	KBRawSQL : public KBasePart
{
	Q_OBJECT

	QSplitter	m_splitter	;
	QWidgetStack	m_stack		;
	QWidget		m_queries	;
	QTabWidget	m_tabber	;
	QLineEdit	m_name		;
	QPushButton	m_bAdd		;
	QPushButton	m_bCopy		;
	QPushButton	m_bRename	;
	QPushButton	m_bExecute	;
	QPushButton	m_bRemove	;

	QList<KBRawSQLPage>
			m_pages		;

	KBDBInfo	*m_dbInfo	;
	QString		m_server	;
	KBDBLink	m_dbLink	;

protected slots :

	void		slotClickAdd	 () ;
	void		slotClickCopy	 () ;
	void		slotClickRename	 () ;
	void		slotClickExecute () ;
	void		slotClickRemove	 () ;

public	:

	KBRawSQL
	(	QWidget		*,
		KBDBInfo	*,
		const QString	&,
		bool		&
	)	;

	virtual	bool	queryClose	 () ;

	inline	QTabWidget	*tabWidget ()
	{
		return	&m_tabber ;
	}
	inline	QWidgetStack	*stack ()
	{
		return	&m_stack  ;
	}
	inline	KBDBLink	&dbLink ()
	{
		return	m_dbLink  ;
	}

	void		setCaption	(const QString &) ;
}	;

#endif	// __KB_RAWSQL_H
