/***************************************************************************
    file	         : kb_objtreeviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>
#include	<qguardedptr.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_object.h"
#include	"kb_nodemonitor.h"
#include	"kb_limit.h"
#include	"kb_layout.h"
#include	"kb_viewer.h"

#include	"kb_listview.h"

#ifndef _WIN32
#include	"kb_objtreeviewer.moc"
#else
#include 	"kb_objtreeviewer.h"
#endif

#include	"tk_icons.h"


/*  KBObjTreeViewer							*/
/*  KBObjTreeViewer							*/
/*		: Constructor for document tree viewer			*/
/*  parent	: QObject *	: Parent object				*/
/*  embed	: QWidget *	: Widget in which to embed the viewer	*/
/*  location	: KBLOcation &	: Document location			*/
/*  rootNode	: KBNode *	: Root node of document			*/
/*  layout	: KBLayout *	: Doucment design layout object		*/

KBObjTreeViewer::KBObjTreeViewer
	(	KBObjBase	*parent,
		QWidget		*embed,
		KBLocation	&location,
		KBNode		*rootNode,
		KBLayout	*layout
	)
	:
	KBViewer 	(parent, embed, WDestructiveClose|WStyle_NormalBorder),
	m_rootNode	(rootNode),
	m_layout	(layout)
{

	m_objTree   = new KBListView  (m_partWidget) ;
	m_topWidget = m_objTree ;

	m_objTree ->addColumn	      (TR("Node") ) ;
	m_objTree ->addColumn	      (TR("Name") ) ;
	m_objTree ->addColumn	      (TR("Value")) ;
	m_objTree ->setRootIsDecorated(true)	   ;
	m_objTree ->setMultiSelection (true)	   ;
	m_objTree ->setSelectionMode  (QListView::Extended) ;

	rootNode->showMonitor	      (m_objTree) ;
	m_objTree ->show		      () ;

	m_gui = new KBaseGUI (this, this, "rekallui.objtree") ;
	setGUI   (m_gui) ;

	m_partWidget->setCaption      (QString(TR("Object Tree: %1")).arg(location.title())) ;
	m_partWidget->setIcon	      (getSmallIcon ("tree")) ;
	m_partWidget->resize 	      (400, 500, true, false) ;
	m_partWidget->show() ;

	connect
	(	m_objTree,
		SIGNAL(doubleClicked   (QListViewItem *)),
		SLOT  (showProperties  ())
	)	;
	connect
	(	m_objTree,
		SIGNAL(selectionChanged()),
		SLOT  (selectionChanged())
	)	;
}

/*  KBObjTreeViewer							*/
/*  ~KBObjTreeViewer							*/
/*		: Destructor for document tree viewer			*/
/*  (returns)	:		:					*/

KBObjTreeViewer::~KBObjTreeViewer ()
{
	if (m_rootNode) m_rootNode->showMonitor ((QListView *)0) ;
}

/*  KBObjTreeViewer							*/
/*  getObjects	: Get list of all selected objects			*/
/*  (returns)	: QList<KBObject>	: Object list			*/

QList<KBObject>
	KBObjTreeViewer::getObjects ()
{
	QList<QListViewItem>	selected = m_objTree->getSelection () ;
	QList<KBObject>		objects	 ;

	KBNode			*node	 ;
	KBObject		*object	 ;
	KBSizer			*sizer	 ;

	LITER
	(	QListViewItem,
		selected,
		item,

		if ((node   = ((KBNodeMonitor *)item)->getNode ()) == 0) continue ;
		if ((object = node  ->isObject()) == 0) continue ;
		if ((sizer  = object->getSizer()) == 0) continue ;

		objects.append (object) ;
	)

	return	objects	;
}

/*  KBObjTreeViewer							*/
/*  showProperties: User double-clicks					*/
/*  (returns)	  : void	    :					*/

void	KBObjTreeViewer::showProperties ()
{
#if	! __KB_RUNTIME
	switch (m_objTree->someSelected (2))
	{
		case 1 :
			m_layout->doSingleProp () ;
			break	;

		case 2 :
			m_layout->doMultiProp  () ;
			break	;

		default	:
			break	;
	}
#endif
}

/*  KBObjTreeViewer							*/
/*  selectionChanged : Handle selection chage				*/
/*  (returns)	     : void	:					*/

void	KBObjTreeViewer::selectionChanged ()
{
#if	! __KB_RUNTIME
	/* This is hard work, we scan the entire object tree to get a	*/
	/* list of all selected objects. To do it more efficiently we	*/
	/* would have to create entries derived from QListViewItem	*/
	/* which notified the KBListView; this is just now worth it.	*/
	QList<KBObject>	objects	 = getObjects () ;

	m_gui->setEnabled ("KB_singleProp", objects.count() == 1) ;
	m_gui->setEnabled ("KB_multiProp",  objects.count() >= 2) ;

	if (!m_objTree->isSelecting())
		for (uint idx = 0 ; idx < objects.count() ; idx += 1)
			m_layout->addSizer (objects.at(idx)->getSizer(), idx > 0) ;
#endif
}

/*  KBObjTreeViewer							*/
/*  doProperties: Show properties dialog				*/
/*  (returns)	: void		:					*/

void	KBObjTreeViewer::doProperties ()
{
#if	! __KB_RUNTIME
	m_layout->doSingleProp () ;
#endif
}

/*  KBObjTreeViewer							*/
/*  doMultiProp	: Show multipe properties dialog			*/
/*  (returns)	: void		:					*/

void	KBObjTreeViewer::doMultiProp ()
{
#if	! __KB_RUNTIME
	m_layout->doMultiProp  () ;
#endif
}

/*  KBObjTreeViewer							*/
/*  showAs	: Show in specified mode				*/
/*  _showAs	: KB::ShowAs	: Show mode				*/
/*  (returns)	: void		:					*/

void	KBObjTreeViewer::showAs
	(	KB::ShowAs
	)
{
	/* Dummy. This viewer only has a single mode.			*/
}
