/***************************************************************************
    file	         : kb_basequery.h
    copyright            : (C) 1999,2000,2001,2002,2003,2004 by Mike Richardson
			   (C) 2001,2002,2003,2004 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef	__KB_BASEQUERY_H
#define	__KB_BASEQUERY_H


#include	<qstring.h>
#include	<qstringlist.h>
#include	<qvaluelist.h>

class	KBDBLink	;

/*  KBBaseQueryValue							*/
/*  ----------------							*/
/*  Class used to store value for a field to be inserted or updated, or	*/
/*  for a where expression (equality only). The "m_type" is type of	*/
/*  the value supplied:							*/
/*		X 	: Used only in copy constructor			*/
/*		V	: Value at execution, uses placeholder		*/
/*		S	: Text string					*/
/*		D	: Integer					*/
/*		F	: Float/double					*/
/*		P	: Value is explicit null			*/
/*  These are based on the "printf" format characters.			*/

class	KBBaseQueryValue
{
	QString		m_field		;
	int		m_type		;
	QString		m_text		;
	int		m_fixed		;
	double		m_float		;

public	:

	KBBaseQueryValue	()	;
	KBBaseQueryValue	(const QString  &)	;
	KBBaseQueryValue	(const QString  &, const QString &)	;
	KBBaseQueryValue	(const QString  &, int   )		;
	KBBaseQueryValue	(const QString  &, double)		;
	KBBaseQueryValue	(const QString  &, void *)		;

	uint	addToUpdate	(KBDBLink *, uint, QStringList &, bool = false ) ;
	uint	addToInsert	(KBDBLink *, uint, QStringList &, QStringList &) ;
}	;


/*  KBBaseQuery								*/
/*  -----------								*/
/*  Base class for building insert/update queries. Contains the table	*/
/*  name and the update/insert values.					*/

class	KBBaseQuery
{
protected	:

	QString				m_table		;
	QValueList<KBBaseQueryValue>	m_values	;

public	:

	KBBaseQuery	(const QString & = QString::null) ;

	void	setTable	(const QString &)	;

	void	addExpression	(const QString &field)	;
	void	addExpression	(const QString &field, const QString &)	;
	void	addExpression	(const QString &field, int   )		;
	void	addExpression	(const QString &field, double)		;
	void	addExpression	(const QString &field, void *)		;
}	;


/*  KBBaseUpdate							*/
/*  ------------							*/
/*  Derived class for constructing update queries. Adds support for an	*/
/*  arbitrary number of "where" conditions.				*/

class	KBBaseUpdate	: public KBBaseQuery
{
	QValueList<KBBaseQueryValue>	m_where	;

public	:

	KBBaseUpdate	(const QString & = QString::null)	;

	void	addWhere	(const QString &field)	;
	void	addWhere	(const QString &field, const QString &)	;
	void	addWhere	(const QString &field, int   )		;
	void	addWhere	(const QString &field, double)		;
	void	addWhere	(const QString &field, void *)		;

	QString	getQueryText	(KBDBLink *)	;
}	;

/*  KBBaseInsert							*/
/*  ------------							*/
/*  Derived class for constructing insert queries.			*/

class	KBBaseInsert	: public KBBaseQuery
{
public	:

	KBBaseInsert	(const QString & = QString::null)	;

	QString	getQueryText	(KBDBLink *)	;
}	;


#endif	// __KB_BASEQUERY_H
