/***************************************************************************
    file	         : kb_dbdociter.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DOCITER_H
#define	__KB_DOCITER_H

#include	<qstring.h>
#include	<qdir.h>

#include	"kb_classes.h"
#include	"kb_dblink.h"
#include	"kb_database.h"

#include	"libcommon_exports.h"


/*  KBDBDocIter								*/
/*  -----------								*/
/*  Document iterator class. This class is used to return the set of	*/
/*  documents of particular type stored in the objects table in a	*/
/*  server, or in the database directory.				*/

class LIBCOMMON_API	KBDBDocIter
{
	KBDBLink		m_dbLink	;
	KBSQLSelect		*m_select	;
	uint			m_nextRow	;

	QDir			m_dbDir		;
	QFileInfoListIterator	*m_dbIter	;
	bool			m_withExtn	;

public	:

	KBDBDocIter (bool = false) ;
       ~KBDBDocIter () ;

	bool	init		(KBDBInfo *, const QString &,
					     const QString &,
					     const QString &, KBError &,
					     bool  = true) ;
	bool	getNextDoc	(QString &, QString &) ;
}	;

#endif	// __KB_DOCITER_H
