/***************************************************************************
    file	         : kb_design.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_dblink.h"
#include	"kb_designinfo.h"


/*  GetKBDesignDictSpec							*/
/*		: Get table specification for design dictionary		*/
/*  spec	: QList<KBFieldSpec>& : Specification list		*/
/*  (returns)	: bool		      : Allways true			*/

LIBCOMMON_API
	bool GetKBDesignDictSpec
	(	QList<KBFieldSpec>	&spec
	)
{
	static	KBFieldSpec	idSpec		(0, "Id",	"Primary Key",	KB::ITFixed,  KBFieldSpec::Primary|
											      KBFieldSpec::Serial, 											    		      8, 0) ;
	static	KBFieldSpec	tabnameSpec	(1, "Tabname",	"_Text",  	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	colnameSpec	(2, "Colname",	"_Text",  	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	descrSpec	(3, "Descrip",	"_Text",	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	evalidSpec	(4, "Evalid", 	"_Text",	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	igncaseSpec	(5, "Igncase",	"_Text",	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	defaultSpec	(6, "Defval",	"_Text",	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	formatSpec	(7, "Format",	"_Text",	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	linkSpec	(8, "Link",	"_Text",	KB::ITString, 0,		    255, 0) ;
	static	KBFieldSpec	widthSpec	(9, "Width",	"_Integer",	KB::ITFixed,  0,		     11, 0) ;

	spec.append (&idSpec)    ;
	spec.append (&tabnameSpec) ;
	spec.append (&colnameSpec) ;
	spec.append (&descrSpec  ) ;
	spec.append (&evalidSpec ) ;
	spec.append (&igncaseSpec) ;
	spec.append (&defaultSpec) ;
	spec.append (&formatSpec ) ;
	spec.append (&linkSpec   ) ;
	spec.append (&widthSpec  ) ;

	spec.setAutoDelete (false) ;
	return	true	;
}

/*  GetKBObjectTableSpec						*/
/*		: Get table specification for object table		*/
/*  spec	: QList<KBFieldSpec>& : Specification list		*/
/*  (returns)	: bool		      : Allways true			*/

LIBCOMMON_API
	bool GetKBObjectTableSpec
	(	QList<KBFieldSpec>	&spec
	)
{
	static	KBFieldSpec	idSpec		(0, "Id",	   "Primary Key", KB::ITFixed,  KBFieldSpec::Primary|
												KBFieldSpec::Serial,   8, 0) ;
	static	KBFieldSpec	nameSpec	(1, "Name",	   "_Text",	  KB::ITString, 0,		      80, 0) ;
	static	KBFieldSpec	typeSpec	(2, "Type",	   "_Text",	  KB::ITString, 0,		      12, 0) ;
	static	KBFieldSpec	textSpec	(3, "Definition",  "_Binary",	  KB::ITString, 0,		   65535, 0) ;
	static	KBFieldSpec	descSpec	(3, "Description", "_Binary",	  KB::ITString, 0,		   65535, 0) ;
	static	KBFieldSpec	timeSpec	(4, "SaveDate",	   "_Text",	  KB::ITString, 0,		      16, 0) ;
	static	KBFieldSpec	extnSpec	(4, "Extension",   "_Text",	  KB::ITString, 0,		      16, 0) ;

	spec.append (&idSpec  ) ;
	spec.append (&nameSpec) ;
	spec.append (&typeSpec) ;
	spec.append (&textSpec) ;
	spec.append (&descSpec) ;
	spec.append (&timeSpec) ;
	spec.append (&extnSpec) ;

	spec.setAutoDelete (false) ;
	return	true	;
}

/*  GetKBDesignQueries							*/
/*		: Construct the design dictionary queries		*/
/*  dbLink	: KBDBLink &	: Database link				*/
/*  (returns)	: void		:					*/

LIBCOMMON_API
	void	GetKBDesignQueries
	(	KBDBLink	&dbLink,
		QString		&selectQuery,
		QString		&insertQuery,
		QString		&updateQuery,
		QString		&deleteQuery
	)
{
	QString	designTab = dbLink.rekallPrefix(DESIGNTABNAME)  ;

	selectQuery  = "select " 			 		;
	insertQuery  = "insert into " + designTab + " values ("		;
	updateQuery  = "update " + designTab + " set "			;
	deleteQuery  = "delete from " + designTab + " where id = " +
				dbLink.placeHolder (0)			;


	QList<KBFieldSpec>   ddSpec  ;
	GetKBDesignDictSpec (ddSpec) ;

	for (uint idx = 0 ; idx < ddSpec.count() ; idx += 1)
	{
		QString	ph = dbLink.placeHolder (idx) ;

		if (idx > 0)
		{	selectQuery += ", "  ;
			insertQuery += ", "  ;
		}

		selectQuery += ddSpec.at(idx)->m_name ;
		insertQuery += ph ;

		if (idx > 1)
			updateQuery += ", " ;
		if (idx > 0)
			updateQuery += ddSpec.at(idx)->m_name + " = " + ph ;
	}

	
	selectQuery += " from " + designTab + " where " ;
	selectQuery += dbLink.keepsCase() ? "tabname = " : "lower(tabname) = " ;
	selectQuery += dbLink.placeHolder (0) ;

	insertQuery += ")" ;
	updateQuery += " where id = " + dbLink.placeHolder (ddSpec.count()) ;

	fprintf	(stderr, "[%s]\n", (cchar *)selectQuery) ;
	fprintf	(stderr, "[%s]\n", (cchar *)insertQuery) ;
	fprintf	(stderr, "[%s]\n", (cchar *)updateQuery) ;
	fprintf	(stderr, "[%s]\n", (cchar *)deleteQuery) ;
}

/*  GETKBDesignEntries							*/
/*		: Get design information for a specified table		*/
/*  tName	: const QString &	: Table name			*/
/*  dDict	: QDict<KBDesignInfo> & : Dictionary to fill		*/
/*  dbLink	: KBDBLink &		: Server link			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	: bool			: Success			*/

LIBCOMMON_API
	bool	GetKBDesignEntries
	(	const QString		&tName,
		QDict<KBDesignInfo>	&dDict,
		KBDBLink		&dbLink,
		KBError			&pError
	)
{
	KBSQLSelect	*select ;
	KBValue		table	(dbLink.keepsCase() ? tName : tName.lower()) ;

	dDict.clear () ;
	if (!dbLink.hasDesignDict()) return true ;

	QString		selectQuery ;
	QString		insertQuery ;
	QString		updateQuery ;
	QString		deleteQuery ;

	GetKBDesignQueries
	(	dbLink,
		selectQuery,
		insertQuery,
		updateQuery,
		deleteQuery
	)	;

	if ((select = dbLink.qrySelect (false, selectQuery)) == 0)
	{
		pError	= dbLink.lastError() ;
		return	false	;
	}


	if (!select->execute (1, &table))
	{
		pError	= select->lastError() ;
		delete	select ;
		return	false	;
	}

	for (uint idx = 0 ; select->rowExists(idx) ; idx += 1)
		dDict.insert
		(	select->getField(idx, DI_COLNAME).getRawText(),
			new KBDesignInfo (select, idx)
		)	;

	delete	select	;
	//select = 0;
	return	true	;
}
