/***************************************************************************
    file	         : kb_designinfo.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_DESIGNINFO_H
#define	_KB_DESIGNINFO_H


/*  KBDesignInfo							*/
/*  ------------							*/
/*  This class holds rows from the design dictionary. This is more	*/
/*  convenient than the general query set code used for normal forms.	*/
/*  Each object holds the complete set of values from a row. Note that	*/
/*  the value if NDIVALS must be the same as the number of columns in	*/
/*  the design dictionary, and must also match the number of entries in	*/
/*  the "infoSets" array in kb_qrydesign.cpp. Further, the define's	*/
/*  below must match the "infoSets" ordering.				*/

#include	"libcommon_exports.h"

#define	DI_ID		0
#define	DI_TABNAME	1
#define	DI_COLNAME	2
#define	DI_DESCR	3
#define	DI_EVALID	4
#define	DI_IGNCASE	5
#define	DI_DEFAULT	6
#define	DI_FORMAT	7
#define	DI_LINK		8
#define	DI_WIDTH	9
#define	DI_NVALS	10


class LIBCOMMON_API	KBDesignInfo
{
	bool	changed		     ;
	KBValue	values	[DI_NVALS+1] ;

public	:

	KBDesignInfo (KBSQLSelect *, uint) ;
	KBDesignInfo (const QString &	 ) ;

	KBValue		*getField	(uint) 			;
	void		setField	(uint, const KBValue &) ;
	void		setField	(uint, const QString &) ;

	inline	bool	hasChanged	()
	{
		return	changed ;
	}
	inline	bool	isInserted	()
	{
		return	values[0] == KBValue() ;
	}
}	;

#endif	// _KB_DESIGNINFO_H
