/***************************************************************************
    file	         : kb_desktop.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qdir.h>
#include	<qfile.h>
#include	<qfileinfo.h>
#include	<qtextstream.h>
#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_desktop.h"


/*  KBDesktop								*/
/*  scan	: Scan for, and decode, desktop files			*/
/*  path	: const QString &    : Directory path			*/
/*  prefix	: const QString &    : Desktop file prefix		*/
/*  desktops	: QDict<KBDesktop> & : Result dictionary		*/
/*  (returns)	: void		     :					*/

void	KBDesktop::scan
	(	const QString		&path,
		const QString		&prefix,
		QList<KBDesktop>	&desktops
	)
{
	QDir	dir	;

	dir.setPath		(path)	;
	dir.setFilter		(QDir::Files) ;
#if	__KB_EMBEDDED
	dir.setNameFilter	(QString("%1*.part")   .arg(prefix)) ;
#else
	dir.setNameFilter	(QString("%1*.desktop").arg(prefix)) ;
#endif

	fprintf
	(	stderr,
		"KBDesktop::scan: scanning [%s]->[%s/%s]\n",
		(cchar *)path,
		(cchar *)dir.absPath   (),
		(cchar *)dir.nameFilter()
	)	;

	const QFileInfoList *list = dir.entryInfoList() ;
	if (list == 0) return ;

	QFileInfoListIterator iter (*list) ;
	QFileInfo *fi ;

	while ((fi = iter.current()) != 0)
	{
		fprintf
		(	stderr,
			"KBDesktop::scan: [%s]\n",
			(cchar *)fi->fileName()
		)	;

		iter += 1 ;

		QFile	file(fi->absFilePath()) ;
		if (!file.open(IO_ReadOnly)) continue ;

		KBDesktop   *dtop = new KBDesktop (fi->fileName()) ;

		QTextStream stream (&file) ;
		QString	    text   ;

		while (!(text = stream.readLine()).isNull())
		{
			QStringList bits = QStringList::split('=', text) ;
			if (bits.count() == 2)
				dtop->insert (bits[0], bits[1]) ;
		}

		desktops.append (dtop) ;
	}
}


/*  KBDesktop								*/
/*  print	: Print desktop definition for debugging		*/
/*  (returns)	: void		:					*/

void	KBDesktop::print ()
{
	QDictIterator<QString> iter(m_entries) ;
	QString	*value	;

	fprintf	(stderr, "%s\n", (cchar *)m_path) ;

	while ((value = iter.current()) != 0)
	{
		fprintf	(stderr, "   %s=%s\n", (cchar *)iter.currentKey(), (cchar *)*value) ;
		iter += 1 ;
	}
}
