/***************************************************************************
    file	         : kb_desktop.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_DESKTOP_H
#define	__KB_DESKTOP_H


#include	<qstring.h>
#include	<qlist.h>
#include	<qdict.h>

#include "libcommon_exports.h"


/*  KBDesktop								*/
/*  ---------								*/
/*  This is a portability class, used to scan a directory for .desktop	*/
/*  files as used by KTrader and friends.				*/

class LIBCOMMON_API	KBDesktop
{
	QString		m_path		;
	QDict<QString>	m_entries	;

public	:

	inline	KBDesktop
		(	const QString	&path
		)
		:
		m_path	(path)
	{
	}

	inline	void	insert
		(	const QString	&key,
			const QString	&value
		)
	{
		m_entries.insert (key, new QString(value)) ;
	}

	inline	QString property
		(	const QString	&key
		)
	{
		QString	*v = m_entries.find (key) ;
		return	v == 0 ? QString::null : *v ;
	}

	void	print	() ;

	static	void	scan
		(	const QString		&,
			const QString		&,
			QList<KBDesktop>	&
		)	;
}	;

#endif	// __KB_DESKTOP_H
