/***************************************************************************
    file	         : kb_tableinfo.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		__KB_TABLEINFO_H
#define		__KB_TABLEINFO_H

#ifdef _WIN32
//#pragma warning(disable : 4251)
#endif

#include	<qlist.h>
#include	<qdict.h>
#include	<qstringlist.h>

#include	"kb_classes.h"
#include	"kb_dom.h"

#include	"libcommon_exports.h"


#define	TI_DESCR	0
#define	TI_EVALID	1
#define	TI_IGNCASE	2
#define	TI_DEFAULT	3
#define	TI_FORMAT	4
#define	TI_LINK		5
#define	TI_WIDTH	6

#define	TI_COUNT	7


typedef	bool	(*QRYMIGRATE) (const QString &) ;


/*  KBTableUnique							*/
/*  -------------							*/
/*  Used simply to store a pair of strings, identifying a column name	*/
/*  and giving a default expression, when a user specifies that a set	*/
/*  of columns are to be treated as unique.				*/

class 	LIBCOMMON_API	KBTableUnique
{
	QString				m_column	;
	QString				m_defval	;

public	:

	inline	KBTableUnique	()
	{
	}

	inline	KBTableUnique
		(	const QString	&column,
			const QString	&defval
		)
		:
		m_column (column),
		m_defval (defval)
	{
	}

	inline	KBTableUnique
		(	const KBTableUnique	*unique
		)
		:
		m_column (unique->m_column),
		m_defval (unique->m_defval)
	{
	}

	inline	const QString	&column () const { return m_column ; }
	inline	const QString	&defval () const { return m_defval ; }
}	;


/*  ------------------------------------------------------------------  */

/*  KBTableUniqueList							*/
/*  -----------------							*/
/*  Shortcut for a list of (column,default) pairs. The complete list	*/
/*  will specify a set of columns that can be treated as uniquely	*/
/*  identifying a row in a table.					*/

class	LIBCOMMON_API	KBTableUniqueList : public QValueList<KBTableUnique>
{
public	:

	KBTableUniqueList	() ;
	KBTableUniqueList	(const KBTableUniqueList &) ;
}	;


/*  ------------------------------------------------------------------  */

/*  KBTableColumn							*/
/*  -------------							*/
/*  This class contains design inforamtion for a column in a table.	*/
/*  This is the meta-data formerly held in the __RekallDesign table.	*/

class	LIBCOMMON_API	KBTableColumn
{
	QString		m_colname		;
	QString		m_design[TI_COUNT]	;	

public	:

	KBTableColumn	(const QString & = QString::null) ;
	KBTableColumn	(const KBTableColumn *)	;

	void		setColumnName	(const QString &) ;
	const	QString	&columnName	()	;
	const	QString	&designValue	(uint)	;
	bool		setDesignValue	(uint, QString  ) ;
	bool		anyValueSet	()	;
}	;


/*  ------------------------------------------------------------------  */

/*  KBTableSort								*/
/*  -----------								*/
/*  Instances of this class are used to hold simple table sorting	*/
/*  information, ie., a list of columns and for each an associated	*/
/*  ascending or descending ordering.					*/

class	LIBCOMMON_API	KBTableSort
{
	QString			m_name		;
	QStringList		m_columns	;
	QValueList<bool>	m_orders	;

public	:

	inline	KBTableSort	
		(	const QString	&name
		)
		:
		m_name	(name)
	{
	}

	KBTableSort	(const QDomElement &)	;

	void			addColumn	(const QString &, bool) ;
	void			sql		(KBDataBuffer  &)	;
	void			save		(QDomElement   &)	;

	inline	const QString	&name		() { return m_name ; }

	friend	class KBTableSortDlg	;
}	;

/*  KBTableSelect							*/
/*  -------------							*/
/*  Similar to KBTableSort, but for filtering (selection). Hold a set	*/
/*  of column names, each with a comparisom operator and a value.	*/

class	LIBCOMMON_API	KBTableSelect
{
public	:

	enum	Operator
	{
		Eq	= 0,
		Neq	= 1,
		Gt	= 2,
		Ge	= 3,
		Lt	= 4,
		Le	= 5,
		Like	= 6,
		NotNull	= 8,
		IsNull	= 9
	}	;

private	:

	QString			m_name		;
	QStringList		m_columns	;
	QValueList<Operator>	m_operators	;
	QStringList		m_values	;

public	:

	inline	KBTableSelect
		(	const QString	&name
		)
		:
		m_name	(name)
	{
	}

	KBTableSelect		(const QDomElement &)	;

	void			addColumn	(const QString &, Operator, const QString &) ;
	void			sql		(KBDataBuffer  &, QDict<KBType> &) ;
	void			save		(QDomElement   &)	;

	inline	const QString	&name		() { return m_name ; }

	friend	class KBTableSelectDlg	;
}	;

/*  KBTableView								*/
/*  -----------								*/
/*  Again similar to KBTableSort, but this time just holds a list of	*/
/*  columns to be shown (in the specified order).			*/

class	LIBCOMMON_API	KBTableView
{
	QString			m_name		;
	QStringList		m_columns	;

public	:

	inline	KBTableView
		(	const QString	&name
		)
		:
		m_name	(name)
	{
	}

	KBTableView		(const QDomElement &)	;

	void			addColumn	(const QString &)	;
	void			save		(QDomElement   &)	;

	inline	const QStringList &columns ()
	{
		return	m_columns ;
	}

	inline	const QString	  &name	()
	{
		return	m_name ;
	}

	friend	class KBTableViewDlg	;
}	;


/*  ------------------------------------------------------------------  */

/*  KBTableInfo								*/
/*  -----------								*/
/*  Class used to hold design information about a table. Subsumes stuff	*/
/*  that was formerly part of the KBDesignInfo code.			*/

class	LIBCOMMON_API	KBTableInfo
{
	QString			m_name		;
	KBTableUniqueList	m_unique	;
	QDict<KBTableColumn>	m_columns	;

	QList<KBTableSort>	m_sortSet	;
	QList<KBTableSelect>	m_selectSet	;
	QList<KBTableView>	m_viewSet	;

	bool			m_changed	;
	bool			m_widthChanged	;

#if	0
	int			loadFromDesign	(KBDBInfo *, const QString &, KBError &) ;
#endif
	int			loadFromInfo	(KBDBInfo *, const QString &, KBError &) ;

public	:

	KBTableInfo		(const QString 	   &)	;

	const 	KBTableUniqueList
				&unique		()	;
	void			setUnique	(const KBTableUniqueList &) ;

	inline	const	QString	&name		()	{ return m_name     ; }
	inline	void	setChanged		()	{ m_changed  = true ; }

	KBTableColumn		*getColumn	(const QString &) ;
	const	QString		&designValue	(const QString &, uint ) ;
	void			setDesignValue	(const QString &, uint, const QString &) ;
	void			update		(QList<KBTableColumn> &) ;

	bool			load		(KBDBInfo *, const QString &, KBError &) ;
	bool			save		(KBDBInfo *, const QString &, KBError &, bool = false) ;

	void			sortList	(QStringList   &) ;
	void			selectList	(QStringList   &) ;
	void			viewList	(QStringList   &) ;

	KBTableSort		*addSort	(const QString &) ;
	KBTableSelect		*addSelect	(const QString &) ;
	KBTableView		*addView	(const QString &) ;

	KBTableSort		*getSort	(const QString &) ;
	KBTableSelect		*getSelect	(const QString &) ;
	KBTableView		*getView	(const QString &) ;
	void			dropSort	(const QString &) ;
	void			dropSelect	(const QString &) ;
	void			dropView	(const QString &) ;

	inline	void	setName
		(	const QString	&name
		)
	{
		m_name	= name	;
	}
}	;


/*  ------------------------------------------------------------------  */

/*  KBTableInfoSet							*/
/*  --------------							*/
/*  This class collects together the table information objects for a	*/
/*  particular server.							*/

class	LIBCOMMON_API	KBTableInfoSet
{
	KBDBInfo		*m_dbInfo	;
	QString			m_server	;
	QDict<KBTableInfo>	m_tableMap	;
	KBError			m_error		;

public	:

	KBTableInfoSet	(KBDBInfo *, const QString &)	;

	void				load		()		;
	void				save		(bool)		;

	KBTableInfo			*getTableInfo	(const QString &) ;

	inline	const KBError		&lastError	()	{ return m_error ; }

	const	KBTableUniqueList	&unique		(const QString &) ;
	void				setUnique	(const QString &, const KBTableUniqueList &) ;

	const	QString			&designValue	(const QString &, const QString &, uint) ;
	void				setDesignValue	(const QString &, const QString &, uint, const QString &) ;

	void				renameTable	(const QString &, const QString &) ;
	void				dropTable	(const QString &) ;

	inline	const QDict<KBTableInfo>&tableMap	()
	{
		return	m_tableMap	;
	}
}	;

#endif		// __KB_TABLEINFO_H
