%token	T_AND
%token	T_ANDIF
%token	T_ANY
%token	T_ASSIGN
%token	T_BREAK
%token	T_CASE
%token	T_CHAR
%token	T_CLOSE
%token	T_COMMA
%token	T_COMP
%token	T_CONST
%token	T_CONTINUE
%token	T_DEFAULT
%token	T_DIV
%token	T_ELSE
%token	T_ENDCASE
%token	T_EQ
%token	T_FOR
%token	T_GLOBAL
%token	T_GT
%token	T_GTEQ
%token	T_IF
%token	T_LBRA
%token	T_LOCAL
%token	T_LSUB
%token	T_MINUS
%token	T_MULT
%token	T_MODULE
%token	T_NEQ
%token	T_NOT
%token	T_NUM
%token	T_DBL
%token	T_NUMBER
%token	T_DOUBLE
%token	T_OPEN
%token	T_OR
%token	T_ORIF
%token	T_NAME
%token	T_PLUS
%token	T_PUBLIC
%token	T_RBRA
%token	T_REM
%token	T_RETURN
%token	T_RSUB
%token	T_SEMI
%token	T_SHL
%token	T_SHR
%token	T_STR
%token	T_STRING
%token	T_SWITCH
%token	T_LT
%token	T_LTEQ
%token	T_USER
%token	T_WHILE
%token	T_XOR

%token	T_APLUS
%token	T_AMINUS
%token	T_AMULT
%token	T_ADIV
%token	T_AREM
%token	T_AOR
%token	T_AAND
%token	T_AXOR
%token	T_INCR
%token	T_DECR

%token	T_QUERY
%token	T_COLON

%token	T_DOT
%token	T_VEC
%token	T_HASH
%token	T_MATCH

%{
#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<string.h>
#include	<setjmp.h>
#include	<std.h>
#undef		INITIAL

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"

LVAR	NAME	*cfunc	;

GFUNC	int	el_getc	() ;
GFUNC	size_t	el_read	(char *, size_t) ;
GFUNC	int	yylex	() ;
GFUNC	void	_el_yyerror (const char *fmt, ...) ;

#if		defined(_DOS) || defined(_WINDOWS)
#define		alloca	malloc
#endif		/* _DOS || _WINDOWS */
%}

%union
{
	ENODE		*enode	;
	const char	*name	;
	STMT		*stmt	;
	CASE		*cases	;
	int		scope	;
	int		value	;

	int		_num	;
	double		_dbl	;
	const char	*_str	;
}

%type	<_num>	T_NUMBER
%type	<_dbl>	T_DOUBLE
%type	<_str>	T_CHAR
%type	<_str>	T_STRING
%type	<_str>	T_NAME

%type	<enode>	assexpr
%type	<enode>	queryexpr
%type	<enode>	binaryexpr
%type	<enode>	unaryexpr
%type	<enode> methodapp
%type	<enode>	expr
%type	<enode>	nulle
%type	<enode> assl
%type	<enode> constant
%type	<name>	name
%type	<stmt>	statement
%type	<stmt>	block
%type	<stmt>	statlist
%type	<cases>	caseitem
%type	<cases>	caselist
%type	<scope>	scope
%type	<value>	value

%right	T_COMMA
%right	T_ASSIGN T_APLUS T_AMINUS T_AMULT T_ADIV T_AREM T_AAND T_AOR T_AXOR
%left	T_ORIF
%left	T_ANDIF
%right	T_QUERY T_COLON
%left	T_OR
%left	T_XOR
%left	T_AND
%left	T_EQ T_NEQ T_MATCH
%left	T_LT T_LTEQ T_GT T_GTEQ
%left	T_SHL T_SHR
%left	T_PLUS T_MINUS
%left	T_MULT T_DIV T_REM
%left	T_LSUB T_RSUB
%right	T_NOT
%right	T_COMP
%left	T_INCR T_DECR
%right	T_VEC
%right	T_HASH
%left	T_LBRA T_RBRA

%%

/*R program								*/
/*R module								*/
/*R declist								*/
/*R declaration	A program is a list of declarations, each of which is	*/
/*		a local or global variable, or a local or global	*/
/*		function. There may be an optional module name.		*/
program:	module ;

module:		T_MODULE name T_SEMI
		{	_el_mname = strdup($2) ;	}
		declist |
		declist ;

declist:	declaration |
		declaration declist ;

declaration:	vardef   |
		funcdef  |
		condef
		;

/*R vardef	A variable is either local or global, the difference	*/
/*		being whether the first word is "local" or "global".	*/
vardef:		scope value name T_SEMI { _el_name ($1|N_VAR, $2, $3) ; } ;


/*R funcdef	A function is either a local or a global function.	*/
/*		These are identical, except that the former starts with	*/
/*		the word "local", and the latter with "global".		*/
funcdef:	scope value name T_LBRA
		{	cfunc	= _el_name   ($1|N_FUNC, $2, $3) ;
			_el_newblk ()	;
			_el_maxblk = 0	;
		}
		varlist T_RBRA block 	{ _el_funcd  ($1, cfunc, $8) ; }
		;

/*R scope	Scope is either local, global or public			*/
scope:		T_GLOBAL	{ $$ = N_GLOBAL ; } |
		T_LOCAL		{ $$ = N_LOCAL  ; } |
		T_PUBLIC	{ $$ = N_PUBLIC ; }
		;

/*R value	Value is either any, number, string, user or none	*/
value:		T_ANY		{ $$ = V_ANY	; } |
		T_NUM		{ $$ = V_NUM	; } |
		T_DBL		{ $$ = V_DBL	; } |
		T_STR		{ $$ = V_STR	; } |
		T_USER		{ $$ = V_USER	; } |
				{ $$ = V_ANY	; }
		;

/*R condef	A constant definition is a name and value pair with	*/
/*		some syntactiv sugar.					*/
condef:		T_CONST name T_ASSIGN constant T_SEMI
		{	_el_newconst ($2, $4) ;
		}	;

constant:	T_NUMBER { $$ = _el_newnumb ($1) ; } |
		T_DOUBLE { $$ = _el_newdbl  ($1) ; } |
		T_STRING { $$ = _el_newstr  ($1) ; } |
		T_CHAR	 { $$ = _el_newchar ($1) ; }
		;

/*R varlist	An variable list is is a list of names separated by	*/
/*		commas.							*/
varlist:	|
		value name
		{	_el_newvdef ($1, $2, NULL) ;
		}
		|
		value name
		{	_el_newvdef ($1, $2, NULL) ;
		}
		T_COMMA varlist
		;

/*R block								*/
/*R loclist								*/
/*R statlist	A block is a sequence (possibly empty) of variable	*/
/*		declarations, followed by a sequence of statements, all	*/
/*		enclosed in braces.					*/
block:		T_OPEN			 { _el_newblk ()	; }
		loclist statlist T_CLOSE { $$ = _el_popblk ($4) ; } |
		T_OPEN			 { _el_newblk ()	; }
		statlist T_CLOSE	 { $$ = _el_popblk ($3)	; }
		;

loclist:	locdecl |
		locdecl loclist
		;

locdecl:	T_LOCAL blklist T_SEMI
		;

blklist:	|
		blkitem |
		blkitem T_COMMA blklist
		;

blkitem:	value name		 { _el_newvdef ($1, $2, NULL) ; } |
		value name T_ASSIGN expr { _el_newvdef ($1, $2, $4  ) ; } 
		;

statlist:	statement	   { $$ = $1		     ; } |
		statement statlist { $1->next = $2 ; $$ = $1 ; }
		;

/*R statement	There are a number of possible statement types		*/
/*		block							*/
/*		if-then and if-then-else conditionals			*/
/*		while and for iterators, with break and continue	*/
/*		return with and without an expression			*/
/*		expression list						*/
statement:	block |
		T_IF T_LBRA expr T_RBRA statement
		{	$$ = _el_newif  ($3, $5, NULL) ;	}
		|
		T_IF T_LBRA expr T_RBRA statement T_ELSE statement
		{	$$ = _el_newif  ($3, $5,   $7) ;	}
		|
		T_WHILE T_LBRA expr T_RBRA 
		{	_el_newiter (NULL, $3, NULL) ;		}
		statement
		{	$$ = _el_enditer ($6) ;			}	
		|
		T_FOR T_LBRA nulle T_SEMI nulle T_SEMI nulle T_RBRA
		{	_el_newiter ($3,   $5,   $7) ;		}
		statement
		{	$$ = _el_enditer ($10) ;		}
		|
		T_SWITCH T_LBRA expr T_RBRA
		{	_el_newswitch ($3) ;
		}
		T_OPEN caselist T_CLOSE
		{	$$ = _el_endswitch ($7) ;
		}
		|
		T_BREAK T_SEMI		{ $$ = _el_newbc (S_BREAK) ; } |
		T_CONTINUE T_SEMI	{ $$ = _el_newbc (S_CONT ) ; } |
		T_ENDCASE T_SEMI	{ $$ = _el_newendc  ()	   ; } |
		T_RETURN T_SEMI		{ $$ = _el_newretn  (NULL) ; } |
		T_RETURN expr T_SEMI	{ $$ = _el_newretn  ($2)   ; } |
		expr T_SEMI		{ $$ = _el_newstand ($1)   ; } |
		T_SEMI			{ $$ = _el_newnulls ()	   ; }
		;

caselist:	caseitem		{		  $$ = $1  ; } |
		caseitem caselist	{ $1->next = $2 ; $$ = $1  ; }
		;

caseitem:	T_CASE expr T_COLON statlist
		{	$$ = _el_newcase ($2,   $4) ; }
		|
		T_DEFAULT	T_COLON statlist
		{	$$ = _el_newcase (NULL, $3) ; }
		;

nulle:			 { $$ = NULL ; } |
		expr	 { $$ = $1   ; }
		;

assexpr:	assl T_ASSIGN expr { $$ = _el_newexpr (O_ASSIGN, $1, $3  ) ; } |
		assl T_APLUS  expr { $$ = _el_newexpr (O_APLUS,  $1, $3  ) ; } |
		assl T_AMINUS expr { $$ = _el_newexpr (O_AMINUS, $1, $3  ) ; } |
		assl T_AMULT  expr { $$ = _el_newexpr (O_AMULT,  $1, $3  ) ; } |
		assl T_ADIV   expr { $$ = _el_newexpr (O_ADIV,   $1, $3  ) ; } |
		assl T_AREM   expr { $$ = _el_newexpr (O_AREM,   $1, $3  ) ; } |
		assl T_AOR    expr { $$ = _el_newexpr (O_AOR,    $1, $3  ) ; } |
		assl T_AAND   expr { $$ = _el_newexpr (O_AAND,   $1, $3  ) ; } |
		assl T_AXOR   expr { $$ = _el_newexpr (O_AXOR,   $1, $3  ) ; }
		;

queryexpr:	expr T_QUERY expr T_COLON expr
		{
			$$		   = _el_newexpr (O_QUERY, $3, $5) ;
			$$->val.expr.query = $1 ;
		}
		;

binaryexpr:	expr T_AND    expr { $$ = _el_newexpr (O_AND,    $1, $3  ) ; } |
		expr T_OR     expr { $$ = _el_newexpr (O_OR,     $1, $3  ) ; } |
		expr T_XOR    expr { $$ = _el_newexpr (O_XOR,    $1, $3  ) ; } |
		expr T_ANDIF  expr { $$ = _el_newexpr (O_ANDIF,  $1, $3  ) ; } |
		expr T_ORIF   expr { $$ = _el_newexpr (O_ORIF,   $1, $3  ) ; } |
		expr T_PLUS   expr { $$ = _el_newexpr (O_PLUS,   $1, $3  ) ; } |
		expr T_MINUS  expr { $$ = _el_newexpr (O_MINUS,  $1, $3  ) ; } |
		expr T_MULT   expr { $$ = _el_newexpr (O_MULT,   $1, $3  ) ; } |
		expr T_DIV    expr { $$ = _el_newexpr (O_DIV,    $1, $3  ) ; } |
		expr T_REM    expr { $$ = _el_newexpr (O_REM,    $1, $3  ) ; } |
		expr T_COMMA  expr { $$ = _el_newexpr (O_COMMA,  $1, $3  ) ; } |
		expr T_NEQ    expr { $$ = _el_newexpr (O_NEQ,    $1, $3  ) ; } |
		expr T_EQ     expr { $$ = _el_newexpr (O_EQ,     $1, $3  ) ; } |
		expr T_LT     expr { $$ = _el_newexpr (O_LT,     $1, $3  ) ; } |
		expr T_LTEQ   expr { $$ = _el_newexpr (O_LTEQ,   $1, $3  ) ; } |
		expr T_GT     expr { $$ = _el_newexpr (O_GT,     $1, $3  ) ; } |
		expr T_GTEQ   expr { $$ = _el_newexpr (O_GTEQ,   $1, $3  ) ; } |
		expr T_SHL    expr { $$ = _el_newexpr (O_SHL,    $1, $3  ) ; } |
		expr T_SHR    expr { $$ = _el_newexpr (O_SHR,    $1, $3  ) ; } |
		expr T_MATCH  expr { $$ = _el_newexpr (O_MATCH,  $1, $3  ) ; }
		;

unaryexpr:	T_NOT    expr { $$ = _el_newexpr (O_NOT,    $2, NULL) ; } |
		T_COMP   expr { $$ = _el_newexpr (O_COMP,   $2, NULL) ; } |
		T_VEC    expr { $$ = _el_newexpr (O_VEC,    $2, NULL) ; } |
		T_HASH   expr { $$ = _el_newexpr (O_HASH,   $2, NULL) ; }
		;

methodapp:	expr T_DOT T_NAME T_LBRA nulle T_RBRA
		{
			$$ = _el_newmethod ($1, $3, $5) ;
		}
		;

expr:		constant	|
		assexpr		|
		queryexpr	|
		binaryexpr	|
		unaryexpr	|
		methodapp	|
		name			     { $$ = _el_newvar  ($1      ) ; } |
		expr T_LBRA nulle T_RBRA     { $$ = _el_newcall ($1, $3  ) ; } |
		T_LBRA expr T_RBRA	     { $$ = $2			   ; }
		|
		expr T_LSUB   expr T_RSUB
				   { $$ = _el_newexpr (O_SUBS,	 $1, $3  ) ; }
		;
/*
		assl T_INCR	   { $$ = _el_newexpr (O_POSTI,  $1, NULL) ; } |
		assl T_DECR	   { $$ = _el_newexpr (O_POSTD,  $1, NULL) ; } |

		T_INCR   assl { $$ = _el_newexpr (O_PREI,	 $2, NULL) ; } |
		T_DECR   assl { $$ = _el_newexpr (O_PRED,	 $2, NULL) ; }
		;
*/
assl:		name		   { $$ = _el_newvar  ($1)	       ; }
		|
		expr T_LSUB   expr T_RSUB
				   { $$ = _el_newexpr (O_SUBL, $1, $3) ; }
		;

name:		T_NAME   { $$ = $1 ; }
		;
%%

#define		YY_NEVER_INTERACTIVE	1
#include	"lex.el_yy.c"

GFUNC	int	el_yywrap ()
{
	return	1 ;
}

GFUNC	void	_el_yyhack ()
{
	yy_init	= 1	 ;
}
