/***************************************************************************
    file	         : print.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<setjmp.h>
#include	<std.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"
#include	"optab.h"

LFUNC	void	pr_vars	(STMT *, NAME *, int) ; 
LFUNC	void	pr_oper	(int) ; 
LFUNC	void	pr_args	(ENODE *) ; 
LFUNC	void	pr_expr	(ENODE *) ; 
LFUNC	void	pr_stmt	(STMT *, int) ; 
LFUNC	void	pr_pars	(NAME *) ; 
LFUNC	void	pr_funcs(FUNC *) ; 


/*L pr_atype	: Get type string					*/
/*  type	: int		: Type value				*/
/*  (returns)	: char *	: Type string				*/

LFUNC	const char *pr_type
	(	int	type
	)
{
	LVAR	char	txt[80]	;

	switch (type & 0xf0)
	{	case N_LOCAL	: return "local"  ;
		case N_GLOBAL	: return "global" ;
		case N_PUBLIC	: return "public" ;
		case N_BLOCK	: return "block"  ;
		default		: break	 ;
	}

	sprintf (txt, "<type %02x>", type & 0xf0) ;
	return	 txt ;
}

/*L pr_vars	: Print variables on list				*/
/*  blk		: STMT *	: Owing block				*/
/*  vlist	: NAME *	: Variable list				*/
/*  id		: int		: Current indent			*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_vars
	(	STMT	*blk,
		NAME	*vlist,
		int	id
	)
{
	if (vlist != NULL)
	{	pr_vars (blk, vlist->next, id) ;
		if (vlist->blk == blk)
		{	printf	("%*s%s %s", id, "",
				 pr_type (vlist->type), vlist->name) ;
			if (vlist->val != NULL)
			{	printf	(" = ") ;
				pr_expr	(vlist->val) ;
			}
			printf	(";\n") ;
		}
	}
}

/*L pr_oper	: Print operator as string				*/
/*  op		: int		: Operator				*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_oper
	(	int	op
	)
{
	if ((op <= 0) || (op > O_MAX))
		printf	(" <oper %d> ", op) ;
	else	printf	(" %s ", optab[op]) ;

}

/*L pr_args	: Print argument list					*/
/*  args	: ENODE *	: Argument list				*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_args
	(	ENODE	*args
	)
{
	for ( ; (args->tag	   == E_EXPR ) &&
		(args->val.expr.op == O_COMMA) ; args = args->val.expr.right)
	{	pr_expr	(args->val.expr.left) ;
		printf	(", ") ;
	}
	pr_expr	(args) ;
}

/*L pr_expr	: Print expression node					*/
/*  expr	: ENODE *	: Expression				*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_expr
	(	ENODE	*expr
	)
{
	switch (expr->tag)
	{
		case E_VAR	:
			printf	("%s", expr->val.var->name) ;
			break	;

		case E_CALL	:
			pr_expr (expr->val.call.func) ;
			printf	("(") ;
			if (expr->val.call.alist != NULL)
				pr_args	(expr->val.call.alist) ;
			printf	(")") ;
			break	;

		case E_NUMB	:
			printf	("%d", expr->val.numb) ;
			break	;

		case E_STRING	:
			printf	("\"%s\"", expr->val.str->name) ;
			break	;

		case E_EXPR	:
			if ( (expr->val.expr.op == O_SUBL) ||
			     (expr->val.expr.op == O_SUBS) )
			{	pr_expr	(expr->val.expr.left ) ;
				printf	("[") ;
				pr_expr	(expr->val.expr.right) ;
				printf	("]") ;
				break	;
			}

			if (expr->val.expr.right != NULL)
			{	printf	("(") ;
				pr_expr	(expr->val.expr.left ) ;
				pr_oper	(expr->val.expr.op   ) ;
				pr_expr	(expr->val.expr.right) ;
				printf	(")") ;
			}
			else
			{	pr_oper	(expr->val.expr.op   ) ;
				printf	("(") ;
				pr_expr	(expr->val.expr.left ) ;
				printf	(")") ;
			}
			break	;

		default :
			printf	(" <expression %d>", expr->tag) ;
			return	;
	}
}

/*L pr_stmt	: Print sequence of statements				*/
/*  stmt	: STMT *	: Statement list			*/
/*  id		: int		: Current indent			*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_stmt
	(	STMT	*stmt,
		int	id
	)
{
	for ( ; stmt != NULL ; stmt = stmt->next) switch (stmt->tag)
	{
		case S_NULLS	:
			printf	("%*s;\n", id, "") ;
			break	;

		case S_BLOCK	:
			printf	("%*s{\n", id, "") ;
			pr_vars	(stmt, stmt->val.block.vars, id + 4) ;
			pr_stmt (stmt->val.block.stmt, id + 4) ;
			printf	("%*s}\n", id, "") ;
			break	;

		case S_RETURN	:
			printf	("%*sreturn", id, "") ;
			if (stmt->val.rete != NULL)
			{	printf	(" ") ;
				pr_expr (stmt->val.rete) ;
			}
			printf	(" ;\n") ;
			break	;

		case S_ITER	:
			printf	("%*sfor (", id, "") ;
			if (stmt->val.iter.init != NULL)
				pr_expr (stmt->val.iter.init) ;
			printf	(" ; ") ;
			if (stmt->val.iter.cond != NULL)
				pr_expr	(stmt->val.iter.cond) ;
			printf	(" ; ") ;
			if (stmt->val.iter.iter != NULL)
				pr_expr (stmt->val.iter.iter) ;
			printf	(")\n") ;
			pr_stmt	(stmt->val.iter.body, id + 4) ;
			printf	("\n" ) ;
			break	;

		case S_STAND	:
			printf	("%*s", id,  "") ;
			pr_expr	(stmt->val.expr) ;
			printf	(" ;\n") ;
			break	;

		case S_BREAK	:
			printf	("%*sbreak ;\n", id, "") ;
			break	;

		case S_CONT	:
			printf	("%*scontinue ;\n", id, "") ;
			break	;

		case S_IFTHEN	:
			printf	("%*sif (", id, "") ;
			pr_expr	(stmt->val.ifthen.cond) ;
			printf	(")\n") ;
			pr_stmt	(stmt->val.ifthen.thenp, id + 4) ;
			if (stmt->val.ifthen.elsep != NULL)
			{	printf	("%*selse\n", id, "") ;
				pr_stmt	(stmt->val.ifthen.elsep, id + 4) ;
			}
			break	;

		default	      :
			printf	("%*s<statement %d> ;\n", id, "", stmt->tag) ;
			return	;
	}
}

/*L pr_pars	: Print parameters					*/
/*  plist	: NAME *	: Parameter list			*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_pars
	(	NAME	*plist
	)
{
	for ( ; plist != NULL ; plist = plist->next)
		printf ("%s%s", plist->name, plist->next == NULL ? "" : ", ") ;
}

/*L pr_funcs	: Print function list					*/
/*  flist	: FUNC *	: List of functions			*/
/*  (returns)	: void		:					*/

LFUNC	void	pr_funcs
	(	FUNC	*flist
	)
{
	for ( ; flist != NULL ; flist = flist->next)
	{	printf	("%s %s (", pr_type (flist->name->type),
					     flist->name->name) ;
		pr_pars	(flist->pars) ;
		printf	(")\n") ;
		pr_stmt	(flist->body, 0) ;
	}
}

/*G _el_print	: Print parsed program					*/
/*  (returns)	: void		:					*/

GFUNC	void	_el_print ()
{
	pr_vars	 (NULL, _el_nlist, 0) ;
	pr_funcs (_el_flist) ;
}
