/***************************************************************************
    file	         : syn.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

typedef	struct	_enode	ENODE	;
typedef	struct	_stmt	STMT	;
typedef	struct	_name	NAME	;
typedef	struct	_func	FUNC	;
typedef	struct	_case	CASE	;

/*S enode	: Node in expression tree				*/
/*  tag		: int		: Tag giving node type			*/
/*  val		: union ...	: Union of possible expression types	*/

struct	_enode
{	int	tag	;
	int	lno	;
	union
	{	NAME	*var	;
		NAME	*str	;
		int	numb	;
		double	dbl	;
		struct
		{	int	op	;
			ENODE	*left	;
			ENODE	*right	;
			ENODE	*query	;
		}	expr	;
		struct
		{	ENODE	*func	;
			ENODE	*alist	;
		}	call	;
		struct
		{	ENODE	*object	;
			NAME	*method	;
			ENODE	*alist	;
		}	method	;
	}	val	;
}	;

/*S stmt	: Statement in statement sequence			*/
/*  next	: STMT *	: Next statement			*/
/*  parent	: STMT *	: Enclosing block			*/
/*  tag		: int		: Tag giving statement type		*/
/*  val		: union ...	: Union of possible statement types	*/

struct	_stmt
{	STMT	*next	;
	STMT	*parent	;
	int	tag	;
	int	lno	;
	union
	{	ENODE	*rete	;
		ENODE	*expr	;
		STMT	*iterp	;
		struct
		{	NAME	*vars	;
			STMT	*stmt	;
		}	block	;
		struct
		{	ENODE	*cond	;
			STMT	*thenp	;
			STMT	*elsep	;
		}	ifthen	;
		struct
		{	ENODE	*init	;
			ENODE	*cond	;
			ENODE	*iter	;
			STMT	*body	;
			int	breakp	;
			int	contp	;
			STMT	*outer	;
		}	iter	;
		struct
		{	ENODE	*value	;
			CASE	*cases	;
			STMT	*outer	;
			int	endp	;
		}	swcase	;
		struct
		{	STMT	*swit	;
		}	endc	;
	}	val	;
}	;

/*S CASE	: Structure for a switch case				*/
/*  next	: CASE *	: Link to next on list			*/
/*  value	: EXPR *	: Case expression			*/
/*  stmt	: STMT *	: Case statement			*/

struct	_case
{	CASE	*next	;
	ENODE	*value	;
	STMT	*stmt	;
}	;

/*S NAME	: Structure used for lists of named things		*/
/*  next	: NAME *	: Next on list				*/
/*  type	: int		: Type  (FUNC,   ...)			*/
/*  value	: int		: Value (NUMBER, ...)			*/
/*  idx		: int		: List index				*/
/*  blk		: STMT		: Block in which declared		*/
/*  val		: VALUE *	: Value of constant or initialisor	*/
/*  ref		: int		: Referenced flag			*/
/*  name	: char *	: Name					*/

struct	_name
{	NAME		*next	;
	int		type	;
	int		value	;
	int		idx	;
	STMT		*blk	;
	const char	*name	;
	ENODE		*val	;
	int		ref	;
}	;

/*S func	: Structure used for lists of functions			*/
/*  next	: FUNC *	: Next on list				*/
/*  name	: NAME *	: Function name				*/
/*  pars	: VLIST *	: Parameter list			*/
/*  size	: int		: Block variable size			*/
/*  body	: STMT *	: Body block				*/

struct	_func
{	FUNC	*next	;
	NAME	*name	;
	NAME	*pars	;
	int	size	;
	STMT	*body	;
}	;


GFUNC	const char	*_el_escape	(const char *sptr, char *tptr, int ext) ;
GFUNC	NAME		*_el_name	(int type, int value, const char *name) ;
GFUNC	void		_el_newblk	(void) ;
GFUNC	STMT		*_el_popblk	(STMT *code) ;
GFUNC	void		_el_funcd	(int type, NAME *name, STMT *body) ;
GFUNC	void		_el_newvdef	(int value, const char *name, ENODE *init) ;
GFUNC	ENODE		*_el_newcall	(ENODE *name, ENODE *alist) ;
GFUNC	ENODE		*_el_newmethod	(ENODE *name, const char *method, ENODE *alist) ;
GFUNC	ENODE		*_el_newnumb	(int numb) ;
GFUNC	ENODE		*_el_newdbl	(double dbl) ;
GFUNC	void		_el_newconst	(const char *name, ENODE *value) ;
GFUNC	ENODE		*_el_newstr	(const char *str) ;
GFUNC	ENODE		*_el_newchar	(const char *str) ;
GFUNC	ENODE		*_el_newexpr	(int op, ENODE *left, ENODE *right) ;
GFUNC	STMT		*_el_newif	(ENODE *cond, STMT *thenp, STMT *elsep) ;
GFUNC	void		_el_newiter	(ENODE *init, ENODE *cond, ENODE *iter) ;
GFUNC	STMT		*_el_enditer	(STMT *body) ;
GFUNC	STMT		*_el_newbc	(int tag) ;
GFUNC	STMT		*_el_newretn	(ENODE *rete) ;
GFUNC	STMT		*_el_newstand	(ENODE *expr) ;
GFUNC	STMT		*_el_newnulls	(void) ;
GFUNC	ENODE		*_el_newvar	(const char *name) ;
GFUNC	CASE		*_el_newcase	(ENODE *value, STMT *stmt) ;
GFUNC	void		_el_newswitch	(ENODE *value) ;
GFUNC	STMT		*_el_endswitch	(CASE *cases) ;
GFUNC	STMT		*_el_newendc	() ;
GFUNC	void		*_el_alloc	(int size) ;
GFUNC	ITEM		*_el_insname	(const char *name, int stat) ;
GFUNC	void		*el_allocate	(int size, const char *where) ;
GFUNC	void		el_yyerror	(const char *fmt, ...) ;

#define	S_BLOCK	 1
#define	S_IFTHEN 2
#define	S_ITER	 3
#define	S_BREAK	 4
#define	S_CONT	 5
#define	S_RETURN 6
#define	S_STAND	 7
#define	S_NULLS	 8
#define	S_SWITCH 9
#define	S_ENDC	 10

#define	E_VAR	 1
#define	E_CALL	 2
#define	E_NUMB	 3
#define	E_DBL	 4
#define	E_STRING 5
#define	E_EXPR	 6
#define	E_METHOD 7

#define	O_PLUS	 1
#define	O_MINUS	 2
#define	O_MULT	 3
#define	O_DIV	 4
#define	O_REM	 5
#define	O_AND	 6
#define	O_OR	 7
#define	O_XOR	 8
#define	O_APLUS	 9
#define	O_AMINUS 10
#define	O_AMULT	 11
#define	O_ADIV	 12
#define	O_AREM	 13
#define	O_AAND	 14
#define	O_AOR	 15
#define	O_AXOR	 16
#define	O_NOT	 17
#define	O_NEQ	 18
#define	O_ANDIF	 19
#define	O_ORIF	 20
#define	O_COMMA	 21
#define	O_ASSIGN 22
#define	O_LT	 23
#define	O_LTEQ	 24
#define	O_GT	 25
#define	O_GTEQ	 26
#define	O_EQ	 27
#define	O_SHL	 28
#define	O_SHR	 29
#define	O_COMP	 30
#define	O_SUBS	 31
#define	O_SUBL	 32
#define	O_PREI	 33
#define	O_POSTI	 34
#define	O_PRED	 35
#define	O_POSTD	 36
#define	O_QUERY	 37
#define	O_VEC	 38
#define	O_HASH	 39
#define	O_MATCH	 40
#define	O_MAX	 40

#define	N_VAR	 0x01		/* Outer variable			*/
#define	N_FUNC	 0x02		/* Function				*/
#define	N_STRING 0x03		/* Text string				*/
#define	N_CONST	 0x05		/* Constant				*/
#define	N_LOCAL	 0x10		/* Local scope				*/
#define	N_GLOBAL 0x20		/* Global scope				*/
#define	N_BLOCK	 0x30		/* Block scope				*/
#define	N_PUBLIC 0x40		/* Public scope				*/
#define	N_TYPE	 0x0f		/* Type bits				*/
#define	N_SCOPE	 0xf0		/* Scope bits				*/

#define	VT_ANY	 0
#define	VT_NUM	 1
#define	VT_STR	 2
#define	VT_USER	 3

GVAR	FUNC	*_el_flist ;	/* List of functions			*/
GVAR	NAME	*_el_nlist ;	/* List of names			*/
GVAR	NAME	*_el_slist ;	/* List of strings			*/
GVAR	int	_el_error  ;	/* Error found flag			*/
GVAR	int	_el_maxblk ;	/* Maximum block variable index		*/
GVAR	char	_el_lname[32] ;	/* Local name				*/
GVAR	char	*_el_mname ;	/* Module name				*/
GVAR	int	el_lineno  ;	/* Current line number			*/
GVAR	char	*el_fname  ;	/* Current file name			*/
GVAR	NAME	*_el_file  ;	/* File being compiled			*/
