/***************************************************************************
    file	         : kb_choice.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_formblock.h"
#include	"kb_choice.h"
#include	"kb_qtchoice.h"
#include	"kb_nodereg.h"
#include	"kb_layout.h"
#include	"kb_finddlg.h"


#if		! __KB_RUNTIME
#include	"kb_propdlg.h"
#endif

#include 	<qstringlist.h>


/*  KBChoice								*/
/*  KBChoice	: Constructor for simple choice field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBChoice::KBChoice
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem		(parent, "KBChoice",	"master", 	aList),
	m_values	(this,   "values",			aList),
	m_nullval	(this,	 "nullval",			aList),
	m_nullOK	(this,	 "nullok",			aList),
	m_editable	(this,	 "editable",			aList),
	m_fgcolor	(this,   "fgcolor",			aList),
	m_bgcolor	(this,   "bgcolor",			aList),
	m_font		(this,	 "font",			aList),
	m_morph		(this,   "morph",			aList,    KF_FORM),
	m_onChange	(this,	 "onchange",	"onChoice",	aList)
{
#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::choicePropDlg (this, "Choice", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true		;
	}
#endif
}

/*  KBChoice								*/
/*  KBChoice	: Constructor for simple choice field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _choice	: KBChoice *	: Extant choice				*/
/*  (returns)	: KBNode	:					*/

KBChoice::KBChoice
	(	KBNode		*_parent,
		KBChoice	*_choice
	)
	:
	KBItem		(_parent, "master", 			_choice),
	m_values	(this,    "values",			_choice),
	m_nullval	(this,	  "nullval",			_choice),
	m_nullOK	(this,	  "nullok",			_choice),
	m_editable	(this,	  "editable",			_choice),
	m_fgcolor	(this,    "fgcolor",			_choice),
	m_bgcolor	(this,    "bgcolor",			_choice),
	m_font		(this,	  "font",			_choice),
	m_morph		(this,    "morph",			_choice, KF_FORM),
	m_onChange	(this,	  "onchange",	"onChoice",	_choice)
{
}

/*  KBChoice								*/
/*  ~KBChoice	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBChoice::~KBChoice ()
{
}

/*  KBChoice								*/
/*  setData	: Set a new set of values				*/
/*  qrow	: uint		: Query row				*/
/*  vals	: void *	: Set of values				*/
/*  (returns)	: void		:					*/

void	KBChoice::setData
	(	uint	,
		void	*vals
	)
{
	m_values.setValue (QString::fromUtf8((cchar *)vals)) ;
	loadValues	  () ;

	/* Pass the data to the controls. Actually, these will use the	*/
	/* KBChoice::getValues() method to get the list of values.	*/
	for (uint idx = 0 ; idx < nCtrls ; idx += 1)
		ctrls[idx]->setData (0) ;
}

/*  KBChoice								*/
/*  setValues	: Set a new set of values				*/
/*  vals	: QStringList &	: Set of values				*/
/*  (returns)	: void		:					*/

void	KBChoice::setValues
	(	const QStringList	&vals
	)
{
	m_valset	= vals ;
	m_valset.insert (m_valset.begin(), m_nullval.getValue()) ;

//	m_valset.clear  ()  ;
//	m_valset.append (m_nullval.getValue()) ;
//
//	for (uint idx1 = 0 ; idx1 < vals->count() ; idx1 += 1)
//		m_valset.append ((*vals)[idx1]) ;

	for (uint idx2 = 0 ; idx2 < nCtrls ; idx2 += 1)
		ctrls[idx2]->setData ((void *)&m_valset) ;
}

/*  KBChoice								*/
/*  loadValues	: Load value set into combo boxes			*/
/*  (returns)	: void		:					*/

void	KBChoice::loadValues ()
{
	m_valset  = QStringList::split
		  (	'|',
			m_nullval.getValue() + "|" + m_values.getValue(),
			true
		  )	;
}


/*  KBChoice								*/
/*  userChange	: Selection changed notification			*/
/*  qrow	: uint		  : Query row number			*/
/*  text	: const QString & : New text				*/
/*  (returns)	: void		  :					*/

void	KBChoice::userChange
	(	uint		qrow,
		const QString	&text
	)
{
	KBValue	args[2]	;
	bool	evRc	;

	args[0] = (int)qrow	 ;
	args[1] = KBValue (text) ;
	eventHook (m_onChange, 2, args, evRc) ;

	KBItem::userChange (qrow) ;
}

/*  KBChoice								*/
/*  keyStroke	: Control has received keystroke			*/
/*  k		: QKeyEvent *	: Key event in question			*/
/*  (returns)	: bool		: Key event consumed			*/

bool	KBChoice::keyStroke
	(	QKeyEvent	*k
	)
{
	/* Override for key up and key down so that we can change	*/
	/* selection, otherwise these keys will navigate between	*/
	/* records.							*/
	if (k->type() == QEvent::KeyPress)
		if ((k->key() == Qt::Key_Up) || (k->key() == Qt::Key_Down))
			return	false	;

	return	KBItem::keyStroke (k) ;
}

/*  KBChoice								*/
/*  showAs	: Switch in and out of design mode			*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBChoice::showAs
	(	KB::ShowAs	mode
	)
{
	if (mode == KB::ShowAsData) loadValues  () ;
	KBItem::showAs (mode) ;
}

/*  KBChoice								*/
/*  makeCtrl	: Make a choice control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: Associated control			*/

KBControl *KBChoice::makeCtrl
	  (	uint		drow
	  )
{
	return	new KBCtrlChoice (getDisplay(), this, drow) ;
}

/*  KBChoice								*/
/*  isMorphing	: Test if field is morphed				*/
/*  (returns)	: bool		: Morphed				*/

bool	KBChoice::isMorphing ()
{
	return	m_morph.getBoolValue() ;
}

/*  KBChoice								*/
/*  checkValid	: Check whether value can be saved in database		*/
/*  value	: const QString & : Text value				*/
/*  alowNull	: bool		  : Ignore not-null check		*/
/*  (returns)	: bool		  : True if OK				*/

bool	KBChoice::checkValid
	(	const QString	&value,
		bool		allowNull
	)
{
	KBError		err	;

	if (!allowNull)
		if (!m_nullOK.getBoolValue() && value.isEmpty())
		{
			setError
			(	KBError::Error,
				TR("Value must be selected from list"),
				QString::null,
				__ERRLOCN
			)	;
			return	false ;
		}

	if (!type->isValid (value, err, name.getValue()))
	{
		setError (err) ;
		return	 false ;
	}

	return	true	;
}


void	KBChoice::setCurrentItem
	(	uint		qrow,
		uint		item
	)
{
	KBControl *ctrl = ctrlAtQRow (qrow) ;
	if (ctrl != 0) ((KBCtrlChoice *)ctrl)->setCurrentItem (item) ;
}

uint	KBChoice::currentItem
	(	uint		qrow
	)
{
	KBControl *ctrl = ctrlAtQRow (qrow) ;
	return	ctrl == 0 ? -1 : ((KBCtrlChoice *)ctrl)->currentItem () ;
}

/*  KBChoice								*/
/*  replicate	: Replicate this choice					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New choice node			*/

KBNode	*KBChoice::replicate
	(	KBNode	*_parent
	)
{
	return	new KBChoice (_parent, this) ;
}

/*  KBChoice								*/
/*  doSearch	: Do record search					*/
/*  (returns)	: void		:					*/

void	KBChoice::doSearch ()
{
	KBFindChoiceDlg findDlg (getFormBlock(), this, m_valset, m_valset) ;
	findDlg.exec () ;
}

#if	! __KB_RUNTIME
/*  KBChoice								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBChoice::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!::choicePropDlg (this, "Choice", attribs, iniAttr)) return false ;

	updateProps ()	;
	return	true	;
}
#endif


NEWNODE(Choice, __TR("New &Choice"), KF_FORM|KF_BLOCK|KF_DATA)
