/***************************************************************************
    file	         : kb_complink.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qobjectlist.h>
#include	<qcursor.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_nodereg.h"
#include	"kb_docroot.h"
#include	"kb_component.h"
#include	"kb_parse.h"
#include	"kb_display.h"
#include	"kb_popupmenu.h"
#include	"kb_config.h"
#include	"kb_override.h"

#include 	"kb_complink.h"


#define	KAF_CONFIG	(KAF_GRPOTHER|KAF_CUSTOM|KAF_HIDDEN)


/*  KBCompLink								*/
/*  KBCompLink	: Constructor for linked component node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBCompLink	:					*/

KBCompLink::KBCompLink
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBFramer	(parent, aList,  "KBCompLink"),
	m_server	(this,	 "server",	aList,	KF_REQD|KAF_GRPDATA),
	m_component	(this,	 "component",	aList,	KF_REQD|KAF_GRPDATA)
{
	KBError	error	;

	m_attrOver = new KBAttrStr (this, "override", "", KAF_CONFIG) ;

	if (!initialise(error))
		if (ok != 0)
		{
			error.DISPLAY()	;
			delete	this	;
			*ok	= false	;
			return	;
		}

	if (ok != 0) *ok = true ;
}

/*  KBCompLink								*/
/*  KBCompLink	: Constructor for component link node			*/
/*  parent	: KBNode *	: Parent node				*/
/*  compLink	: KBCompLink *	: Extant component link			*/
/*  (returns)	: KBCompLink	:					*/

KBCompLink::KBCompLink
	(	KBNode		*parent,
		KBCompLink 	*compLink
	)
	:
	KBFramer	(parent, compLink),
	m_server	(this,	 "server",	compLink,	KF_REQD|KAF_GRPDATA),
	m_component	(this,	 "component",	compLink,	KF_REQD|KAF_GRPDATA)
{
	m_attrOver = new KBAttrStr (this, "override", "", KAF_CONFIG) ;
}

/*  KBCompLink								*/
/*  KBCompLink	: Destructor for component link node			*/
/*  (returns)	:		:					*/

KBCompLink::~KBCompLink ()
{
	DELOBJ	(m_attrOver) ;
}

/*  KBCompLink								*/
/*  initialise	: Initialise component					*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBCompLink::initialise
	(	KBError		&pError
	)
{
	QByteArray data	 ;
	KBLocation locn
		   (	getDocRoot()->getLocation().dbInfo,
			"component",
			m_server   .getValue(),
			m_component.getValue(),
			"cmp"
		   )	;

	if (!locn.contents (data, pError))
		return	false	;


	KBLocation  doc		= getDocRoot()->getLocation () ;
	KBComponent *component	= KBOpenComponentText (doc, data, pError) ;
	if (component == 0)
		return	false	;


	/* We have a valid component, so replicate the objects in the	*/
	/* component into this node, with the exception of any top-	*/
	/* level null query node, adjusted by the minimum position.	*/
	/* Also grab the configuration object for later use.		*/
	const QList<KBNode> &cList	= component->getChildren() ;
	KBObject	    *oObj	;
	int		    minx	;
	int		    miny	;

	minPosition (cList, minx, miny) ;

	LITER
	(	KBNode,
		cList,
		child,

		if (child->isQryNull())
			continue ;

		if ((oObj = child->isObject()) == 0)
			continue ;

		/* Subtle bit. We want the nodes to be created with	*/
		/* their adjusted geometry, otherwise they move if the	*/
		/* user switches from data to design view. Do this my	*/
		/* updating the component object before replicating it.	*/
		/* This is OK as the component object will be deleted	*/
		/* below.						*/
		QRect r  = oObj->geometry() ;
		r.moveBy (-minx, -miny) ;
		oObj->setGeometry   (r) ;

		oObj->replicate	     (this)->isObject() ;
	)

	delete	component ;
	return	true ;
}

/*  KBCompLink								*/
/*  checkOverrides							*/
/*		: Check the overrides are valid				*/
/*  (returns)	: void		:					*/

void	KBCompLink::checkOverrides ()
{
	/* The configurations for the component may have been changed.	*/
	/* Add any new ones that are not known about, and remove any	*/
	/* that we defunct. This also handles the case where the user	*/
	/* add a linked component to a form or report.			*/
	QList<KBConfig> configSet ;

	CITER
	(	Object,
		o,
		o->findAllConfigs (configSet, QString::null) ;
	)

	/* The nested loops scan the overrides, and look for the	*/
	/* corresponding config. If found, then remove the config from	*/
	/* its list; if not found then delete the override. At the end	*/
	/* all remaining overrides still have configs, and the config	*/
	/* list has new configs.					*/
	/* NOTE: This is horribly inneficient but we should only have	*/
	/*	 small numbers.						*/
	CITER
	(	Override,
		r,

		fprintf
		(	stderr,
			"KBCompLink::initialise: extant [%s][%s]\n",
			(cchar *)r->path  (),
			(cchar *)r->attrib()
		)	;

		bool	found	= 0 ;
		LITER
		(	KBConfig,
			configSet,
			c,

			if ((c->path() == r->path()) && (c->attrib() == r->attrib()))
			{
				configSet.remove (c) ;
				found	= true	;
				break	;
			}
		)

		if (!found)
		{
			fprintf
			(	stderr,
				"KBCompLink::initialise: dropping [%s][%s]\n",
				(cchar *)r->path  (),
				(cchar *)r->attrib()
			)	;
			delete	r ;
		}
	)

	LITER
	(	KBConfig,
		configSet,
		c,

		fprintf
		(	stderr,
			"KBCompLink::initialise: adding [%s][%s]\n",
			(cchar *)c->path  (),
			(cchar *)c->attrib()
		)	;

		new KBOverride
			(	this,
				c->ident (),
				c->path  (),
				c->attrib(),
				c->value (),
				false
			)	;
	)
}

/*  KBCompLink								*/
/*  endParse	: Post-parsing handler					*/
/*  (returns)	: KBNode *	: The node				*/

KBNode	*KBCompLink::endParse ()
{
	/* Check if the component configuration has changed. We do this	*/
	/* there since we at the time the constructor is called, any	*/
	/* child overrides will not yet exist.				*/
	checkOverrides () ;
	return	KBFramer::endParse() ;
}

/*  KBCompLink								*/
/*  replicate	: Replicate this component link				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New component link node		*/

KBNode	*KBCompLink::replicate
	(	KBNode	*_parent
	)
{
	return	replicateBelow (new KBCompLink (_parent, this)) ;
}

/*  KBCompLink								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCompLink::showAs
	(	KB::ShowAs	mode
	)
{
	KBFramer::showAs (mode) ;

	const QObjectList *children = frmDisp->getTopWidget()->children() ;
	if (children != 0)
	{
		QObjectListIt iter (*children) ;
		QObject	      *obj ;

		while ((obj = iter.current()) != 0)
		{
			++iter ;

			if (!obj->isWidgetType())
				continue ;

			if (obj->isA("KBSizerBlob"))
				continue ;

			((QWidget *)obj)->setEnabled (mode == KB::ShowAsData) ;
		}
	}

	if (mode == KB::ShowAsData)
		setOverrides	() ;
}

/*  KBCompLink								*/
/*  setOverrides: Set override values					*/
/*  (returns)	: void		:					*/

void	KBCompLink::setOverrides ()
{
	QStringList	missed	;
	QList<KBObject>	subbed	;

	CITER
	(	Override,
		o,

		if (!o->enabled()) continue ;

		KBObject *obj = o->substitute() ;

		if (obj == 0)
			missed.append(QString("%1: %2").arg(o->path()).arg(o->attrib())) ;
		else	subbed.append(obj) ;
	)

	if (missed.count() > 0)
	{
		KBError::EError
		(	TR("Failed to find some attributes when linking component"),
			missed.join("\n"),
			__ERRLOCN
		)	;
		return	;
	}

	LITER
	(	KBObject,
		subbed,
		o,
		o->updateProps()
	)
}

/*  KBCompLink								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBCompLink::printNode
	(	QString	&text,
		int	indent
	)
{
	QString	nodeText ;

	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;
	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;
	text	+= ">\n" ;

	CITER
	(	Config,
		c,

		c->printNode (text, indent + 2) ;
	)
	CITER
	(	Override,
		o,

		o->printNode (text, indent + 2) ;
	)

	text	+= nodeText ;
	text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
}

#if	! __KB_RUNTIME

/*  KBCompLink								*/
/*  designPopup	: Handle design menu request				*/
/*  e		: QMouseEvent *	: Associated mouse event		*/
/*  drow	: uint		: Display row				*/
/*  (returns)	: void		:					*/

void	KBCompLink::designPopup
	(	QMouseEvent	*e,
		uint
	)
{
	KBPopupMenu popupMain	(&bState) ;
	KBPopupMenu *popupEdit	= new KBPopupMenu (&bState) ;

	popupEdit->insertEntry (false,	TR("C&ut component"  ),  this, SLOT(cutObj   	())) ;
	popupEdit->insertEntry (false,	TR("&Copy component" ),  this, SLOT(copyObj  	())) ;
	popupEdit->insertEntry (false,	TR("Delete component"),  this, SLOT(deleteObj	())) ;
 
	popupMain .insertItem  (TR("Cancel")) ;
	popupMain .insertItem  (TR("&Edit"), popupEdit) ;

	/* Add a menu option for the properties of this object itself.	*/
	popupMain .insertItem
	(	TR("Component properties"),
		this,
		SLOT(propertyDlg ())
	)	;

	/* If there is an owning block then provide access to that	*/
	/* blocks properties.						*/
	popupMain .insertItem
	(	TR("Block &properties"),
		this,
		SLOT(blockPropDlg())
	)	;

	/* Lastly, add a menu item to access the property dialog of the	*/
	/* document itself.						*/
	popupMain .insertItem
	(	TR("&Document properties"),
		this,
		SLOT(docPropDlg())
	)	;

	insertAt	= e->pos ()	 ;
	newRect		= QRect  ()	 ;
	popupMain .exec	(QCursor::pos()) ;
}


/*  KBCompLink								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniattr	: cchar *	: Initial attribute			*/ 
/*  (returns)	: bool		: Success				*/

bool	KBCompLink::propertyDlg ()
{
	return	propertyDlg (0) ;
}

/*  KBCompLink								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBCompLink::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!::compLinkPropDlg (this, "Linked Component", attribs, iniAttr)) return false ;

	updateProps ()	;
	return true     ;
}
#endif

NEWNODE(CompLink, (cchar *)0, KF_FORM|KF_REPORT)
