/***************************************************************************
    file	         : kb_componentdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include	"kb_componentdlg.moc"
#else
#include	"kb_componentdlg.h"
#endif

#include	"kb_component.h"
#include	"kb_param.h"

#include	"tk_messagebox.h"



static	IntChoice	choiceCType[] =
{
	{	KB::ObjUnknown,	""			},
	{	KB::ObjForm,	"Form component"	},
	{	KB::ObjReport,	"Report component"	},
	{	-1,		0			}
}	;


/*  KBComponentPropDlg							*/
/*  KBComponentPropDlg							*/
/*		: Constructor for root properties dialog		*/
/*  root	: KBComponent *	   : Root node				*/
/*  caption	: cchar *	   : Caption text			*/
/*  attribs	: QList<KBAttr  >& : Attributes list			*/
/*  params	: QList<KBParam >& : List of parameters modules		*/
/*  iniAttr	: cchar *	   : Initial attribute			*/
/*  (returns)	: KBComponentPropDlg   :					*/

KBComponentPropDlg::KBComponentPropDlg
	(	KBComponent	*root,
		cchar		*caption,
		QList<KBAttr  >	&attribs,
		QList<KBParam > &params, 
		cchar		*iniAttr
	)
	:
	KBPropDlg (root, caption, attribs, iniAttr),
	paramDlg  (&topWidget, root, params),
	root	  (root)
{
	paramDlg .hide() ;
}

/*  KBComponentPropDlg							*/
/*  ~KBComponentPropDlg							*/
/*		: Destructor for component properties dialog		*/
/*  (returns)	:		:					*/

KBComponentPropDlg::~KBComponentPropDlg ()
{
}

/*  KBComponentPropDlg							*/
/*  hideProperty : Check whether to hide attribute property		*/
/*  attr	 : KBAttr *	: Attribute in question			*/
/*  (returns)	 : bool		: True to hide				*/

bool	KBComponentPropDlg::hideProperty
	(	KBAttr	*attr
	)
{
	const QString	&name	= attr->getName () ;

	if ( (name == "paramlist") ||
	     (name == "type"	 ) ||
	     (name == "notes"	 ) ) return false ;

	return	true	;
}

/*  KBComponentPropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem *KBComponentPropDlg::getAttrItem
	(	KBAttr	*attr
	)
{
	if (attr->getName() == "type")
		return	new KBAttrIntChoice (attr, choiceCType, KB::ObjUnknown) ;

	return	KBPropDlg::getAttrItem (attr) ;
}

/*  KBComponentPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBComponentPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	QString	aName	= item->attr()->getName () ;

	if (aName == "paramlist")
	{
		setUserWidget (&paramDlg ) ;
		return	true	 ;
	}

	if (aName == "type")
	{
		if ((KB::ObjType)item->value().toInt() != KB::ObjUnknown)
		{
			TKMessageBox::sorry
			(	0,
				TR("Once set, a component type cannot be changed"),
				TR("Component type")
			)	;
			return	false	;
		}

		showChoices (item, choiceCType, item->value()) ;
		return	true ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBComponentPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBComponentPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	QString	aName	= item->attr()->getName() ;

	if (aName == "paramlist")
	{
		setProperty  ("paramlist", paramDlg .getText()) ;
		return	true ;
	}

	if (aName == "type")
	{
		saveChoices (item, choiceCType) ;
		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBComponentPropDlg:							*/
/*  clickOK	 : Handle OK button click				*/
/*  (returns)	 : void		:					*/

void	KBComponentPropDlg::clickOK ()
{
	paramDlg .fixUp () ;

	KBPropDlg::clickOK () ;
}

/*  KBComponentPropDlg:							*/
/*  preExec	  : Called immediately before QDialog::exec		*/
/*  (returns)	  : void	:					*/

void	KBComponentPropDlg::preExec ()
{
	/* Trap this and load the notional hidden attribute. We have to	*/
	/* do this here since it is not until "KBPropDlg::exec" has	*/
	/* been called that "setProperty" will work.			*/
	setProperty  ("paramlist", paramDlg.getText()) ;
}


/*  componentPropDlg							*/
/*		: Run the root properties dialog box			*/
/*  form	: KBComponent *	   : Form node				*/
/*  caption	: cchar *	   : Caption text			*/
/*  attribs	: QList<KBAttr  >& : Attributes list			*/
/*  params	: QList<KBParam >& : List of parameters modules		*/
/*  iniAttr	: cchar *	   : Initial attribute			*/
/*  (returns)	: bool		   : Success				*/

bool	LIBKBASE_API componentPropDlg
	(	KBComponent	*component,
		cchar		*caption,
		QList<KBAttr  >	&attribs,
		QList<KBParam > &params, 
		cchar		*iniAttr
	)
{
	KBComponentPropDlg cDlg (component, caption, attribs, params, iniAttr) ;
	return	cDlg.exec  () ;
}
