/***************************************************************************
    file	         : kb_display.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_DISPLAY_H
#define	_KB_DISPLAY_H

#include	<qsize.h>
#include 	<qguardedptr.h>


#include 	"libkbase_exports.h"
#include	"kb_classes.h"

class		KBDispWidget	;
class		KBDispScroller	;
class		QWidget		;
class		QScrollView	;


/*  KBDisplay								*/
/*  ---------								*/
/*  This class is effectively the widget onto which forms and the like	*/
/*  place their controls. However, since the top-most block must be	*/
/*  shows in a scroller (becuase the form can be very large, especially	*/
/*  the width of a table data display), KBDisplay provides an interface	*/
/*  which hides the various differences.				*/

class	LIBKBASE_API	KBDisplay
{
	QGuardedPtr<KBDispScroller>	scroller ;
	QGuardedPtr<KBDispWidget>	widget	 ;
	QGuardedPtr<QWidget>		canvas	 ;

	QSize		topSize	 ;	/* Logical top-level size	*/

	bool		marking	 ;
	int		startMX	 ;
	int		startMY	 ;
	int		markX	 ;
	int		markY	 ;
	int		markW	 ;
	int		markH	 ;
	QSize		bounds	 ;	/* Marking area bounds		*/
	KB::ShowAs	showing	 ;	/* In design mode		*/
	bool		shown	 ;

	int		m_left	 ;
	int		m_top	 ;

protected :

	KBDisplay	*parent	 ;	/* Parent display if any	*/
	KBObject	*owner	 ;	/* Owning object		*/

public	:

	KBDisplay (QWidget   *, KBObject *, uint, bool, bool = false) ;
	KBDisplay (KBDisplay *, KBObject *, uint) ;
	virtual	~KBDisplay () ;

	void		addChild   		(QWidget     *, int, int) ;
	void		moveChild  		(QWidget     *, int, int) ;

	void		addMorph		(KBItem      *) ;
	void		remMorph		(KBItem      *) ;
	void		updateMorph		(KBItem      *, const QRect &) ;
	void		updateMorph		(KBItem      *, uint) ;

	void		move			(int, int) 	;
	void		resize			(int, int) 	;

	void		showAs			(KB::ShowAs)	;
	void		setStretchable		(bool)		;
	void		setShowbar		(uint)		;

	void		setTitle		(const QString  &) ;
	void		setPalette 		(const QPalette *) ;
	void		setFont    		(const QFont    *) ;
	void		show	   		() ;
	int		width	   		() ;
	int		height	   		() ;

	QSize		getBaseSize		() ;

	void		displayIsGone		() ;
	QWidget		*getTopWidget		() ;
	QWidget		*getDisplayWidget	() ;
	QSize		effectiveSize		() ;
	QSize		getSizeNeeded		(const QSize &) ;
	void		makeVisible		(const QRect &, QFocusEvent::Reason) ;
	void		cvtViewToCtrl		(      QRect &) ;
	void		cvtCtrlToView		(      QRect &) ;

	void		setFrame		(int, int)	;

	const QPalette  palette			() ;
	const QFont     font			() ;
	QScrollView	*getScroller		() ;

#if	! __KB_RUNTIME
	bool		markStart  		(QMouseEvent *) ;
	bool		contextEvent		(QWidget  *, QMouseEvent *) ;
	bool		markStartEvent		(QWidget  *, QMouseEvent *) ;
	void		markMoveEvent		(QWidget  *, QMouseEvent *) ;
	bool		markEndEvent		(QWidget  *, QMouseEvent *) ;
	void		drawDisplay		(QPainter *, QRect) ;
#endif

	void		setRowRange		(uint, uint, uint, uint, uint ) ;	
	void		scrollToRow		(uint) ;
	void		scrollBy		( int) ;
	void		doAction		(KB::Action ) ;
	bool		keyStroke		(QKeyEvent *) ;
	void		resizeEvent		(uint,  uint) ;

	void		setTagLabel		(const QString &) ;

	inline	QSize	  getTopSize 	()
	{
		return	topSize  ;
	}
	inline	KBDisplay *getParent 	()
	{
		return	parent   ;
	}
	inline	KBObject  *getOwner	()
	{
		return	owner	 ;
	}
}	;

#endif	// _KB_DISPLAY_H
