/***************************************************************************
    file	         : kb_dumper.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qstring.h>
#include	<qlabel.h>
#include	<qcheckbox.h>
#include	<qlistview.h>
#include	<qpushbutton.h>

#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_dialog.h"


class	KBDumperItem : public QCheckListItem
{
	KBTableDetails	*m_details	;

public	:

	inline	KBDumperItem
		(	QListView	*parent,
			KBTableDetails	*details
		)
		:
		QCheckListItem
		(	parent,
			details->m_name,
			QCheckListItem::CheckBox
		),
		m_details	(details)
	{
		setText	(1, details->typeText()) ;
	}

	inline	KBTableDetails	*details ()
	{
		return	m_details	;
	}
}	;


/*  KBDumper								*/
/*  --------								*/
/*  Database dumper class, used when bulk dumping table definitions	*/
/*  and data.								*/

class	KBDumper : public _KBDialog
{
	Q_OBJECT

	QCheckBox		m_dumpAll	;
	QCheckBox		m_dumpDefn	;
	QCheckBox		m_dumpData	;
	QListView		m_tableList	;

	QLabel			m_dumping	;
	QLabel			m_record	;
	QLabel			m_of		;
	QPushButton		m_bOK		;
	QPushButton		m_bCancel	;

	KBDBInfo		*m_dbInfo	;
	QString			m_server	;
	QString			m_dir		;

	bool			m_cancelled	;
	bool			m_finished	;

	KBDBLink		m_dbLink	;
	KBTableDetailsList	m_tables 	;
	uint			m_index		;
	KBDumperItem		*m_currItem	;

	bool			dumpTableDef	(KBTableSpec	&, KBError &) ;
	bool			dumpTableData	(KBTableSpec	&, KBError &) ;
	bool			dumpViewDef	(KBTableSpec	&, KBError &) ;
	bool			dumpSequenceDef	(KBSequenceSpec	&, KBError &) ;

	bool			dumpDetails	(KBTableDetails *) ;

protected slots :

	void		accept	 	()	;
	void		reject	 	()	;
	void		slotTimer	()	;

public	:

	KBDumper (KBDBInfo *, const QString &, const QString &) ;

	int		exec		()	;
	bool		showProgress	(int)	;
}	;
